<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DisturbanceActivity StructType
 * @subpackage Structs
 */
class DisturbanceActivity extends Activity
{
    /**
     * The disturbanceActivityType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $disturbanceActivityType;
    /**
     * The disturbanceActivityExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $disturbanceActivityExtension;
    /**
     * Constructor method for DisturbanceActivity
     * @uses DisturbanceActivity::setDisturbanceActivityType()
     * @uses DisturbanceActivity::setDisturbanceActivityExtension()
     * @param string $disturbanceActivityType
     * @param \StructType\ExtensionType $disturbanceActivityExtension
     */
    public function __construct($disturbanceActivityType = null, \StructType\ExtensionType $disturbanceActivityExtension = null)
    {
        $this
            ->setDisturbanceActivityType($disturbanceActivityType)
            ->setDisturbanceActivityExtension($disturbanceActivityExtension);
    }
    /**
     * Get disturbanceActivityType value
     * @return string
     */
    public function getDisturbanceActivityType()
    {
        return $this->disturbanceActivityType;
    }
    /**
     * Set disturbanceActivityType value
     * @uses \EnumType\DisturbanceActivityTypeEnum::valueIsValid()
     * @uses \EnumType\DisturbanceActivityTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $disturbanceActivityType
     * @return \StructType\DisturbanceActivity
     */
    public function setDisturbanceActivityType($disturbanceActivityType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DisturbanceActivityTypeEnum::valueIsValid($disturbanceActivityType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $disturbanceActivityType, implode(', ', \EnumType\DisturbanceActivityTypeEnum::getValidValues())), __LINE__);
        }
        $this->disturbanceActivityType = $disturbanceActivityType;
        return $this;
    }
    /**
     * Get disturbanceActivityExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getDisturbanceActivityExtension()
    {
        return $this->disturbanceActivityExtension;
    }
    /**
     * Set disturbanceActivityExtension value
     * @param \StructType\ExtensionType $disturbanceActivityExtension
     * @return \StructType\DisturbanceActivity
     */
    public function setDisturbanceActivityExtension(\StructType\ExtensionType $disturbanceActivityExtension = null)
    {
        $this->disturbanceActivityExtension = $disturbanceActivityExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DisturbanceActivity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
