<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for DIRECTION.
 * @subpackage Structs
 */
class DirectionStructure extends AbstractStructBase
{
    /**
     * The DirectionRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifer of DIRECTION,
     * @var \StructType\DirectionRefStructure
     */
    public $DirectionRef;
    /**
     * The DirectionName
     * Meta informations extracted from the WSDL
     * - documentation: Description of DIRECTION. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $DirectionName;
    /**
     * Constructor method for DirectionStructure
     * @uses DirectionStructure::setDirectionRef()
     * @uses DirectionStructure::setDirectionName()
     * @param \StructType\DirectionRefStructure $directionRef
     * @param \StructType\NaturalLanguageStringStructure[] $directionName
     */
    public function __construct(\StructType\DirectionRefStructure $directionRef = null, array $directionName = array())
    {
        $this
            ->setDirectionRef($directionRef)
            ->setDirectionName($directionName);
    }
    /**
     * Get DirectionRef value
     * @return \StructType\DirectionRefStructure|null
     */
    public function getDirectionRef()
    {
        return $this->DirectionRef;
    }
    /**
     * Set DirectionRef value
     * @param \StructType\DirectionRefStructure $directionRef
     * @return \StructType\DirectionStructure
     */
    public function setDirectionRef(\StructType\DirectionRefStructure $directionRef = null)
    {
        $this->DirectionRef = $directionRef;
        return $this;
    }
    /**
     * Get DirectionName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getDirectionName()
    {
        return $this->DirectionName;
    }
    /**
     * Set DirectionName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $directionName
     * @return \StructType\DirectionStructure
     */
    public function setDirectionName(array $directionName = array())
    {
        foreach ($directionName as $directionStructureDirectionNameItem) {
            // validation for constraint: itemType
            if (!$directionStructureDirectionNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The DirectionName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($directionStructureDirectionNameItem) ? get_class($directionStructureDirectionNameItem) : gettype($directionStructureDirectionNameItem)), __LINE__);
            }
        }
        $this->DirectionName = $directionName;
        return $this;
    }
    /**
     * Add item to DirectionName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\DirectionStructure
     */
    public function addToDirectionName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The DirectionName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DirectionName[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DirectionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
