<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataNameSpacesStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Name spaces.
 * @subpackage Structs
 */
class DataNameSpacesStructure extends AbstractStructBase
{
    /**
     * The StopPointNameSpace
     * Meta informations extracted from the WSDL
     * - documentation: Name space for STOP POINTs.
     * - minOccurs: 0
     * @var string
     */
    public $StopPointNameSpace;
    /**
     * The LineNameSpace
     * Meta informations extracted from the WSDL
     * - documentation: Name space for LINE names and DIRECTIONss.
     * - minOccurs: 0
     * @var string
     */
    public $LineNameSpace;
    /**
     * The ProductCategoryNameSpace
     * Meta informations extracted from the WSDL
     * - documentation: Name space for Product Categories.
     * - minOccurs: 0
     * @var string
     */
    public $ProductCategoryNameSpace;
    /**
     * The ServiceFeatureNameSpace
     * Meta informations extracted from the WSDL
     * - documentation: Name space for service features.
     * - minOccurs: 0
     * @var string
     */
    public $ServiceFeatureNameSpace;
    /**
     * The VehicleFeatureNameSpace
     * Meta informations extracted from the WSDL
     * - documentation: Name space for VEHICLE features.
     * - minOccurs: 0
     * @var string
     */
    public $VehicleFeatureNameSpace;
    /**
     * Constructor method for DataNameSpacesStructure
     * @uses DataNameSpacesStructure::setStopPointNameSpace()
     * @uses DataNameSpacesStructure::setLineNameSpace()
     * @uses DataNameSpacesStructure::setProductCategoryNameSpace()
     * @uses DataNameSpacesStructure::setServiceFeatureNameSpace()
     * @uses DataNameSpacesStructure::setVehicleFeatureNameSpace()
     * @param string $stopPointNameSpace
     * @param string $lineNameSpace
     * @param string $productCategoryNameSpace
     * @param string $serviceFeatureNameSpace
     * @param string $vehicleFeatureNameSpace
     */
    public function __construct($stopPointNameSpace = null, $lineNameSpace = null, $productCategoryNameSpace = null, $serviceFeatureNameSpace = null, $vehicleFeatureNameSpace = null)
    {
        $this
            ->setStopPointNameSpace($stopPointNameSpace)
            ->setLineNameSpace($lineNameSpace)
            ->setProductCategoryNameSpace($productCategoryNameSpace)
            ->setServiceFeatureNameSpace($serviceFeatureNameSpace)
            ->setVehicleFeatureNameSpace($vehicleFeatureNameSpace);
    }
    /**
     * Get StopPointNameSpace value
     * @return string|null
     */
    public function getStopPointNameSpace()
    {
        return $this->StopPointNameSpace;
    }
    /**
     * Set StopPointNameSpace value
     * @param string $stopPointNameSpace
     * @return \StructType\DataNameSpacesStructure
     */
    public function setStopPointNameSpace($stopPointNameSpace = null)
    {
        // validation for constraint: string
        if (!is_null($stopPointNameSpace) && !is_string($stopPointNameSpace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stopPointNameSpace)), __LINE__);
        }
        $this->StopPointNameSpace = $stopPointNameSpace;
        return $this;
    }
    /**
     * Get LineNameSpace value
     * @return string|null
     */
    public function getLineNameSpace()
    {
        return $this->LineNameSpace;
    }
    /**
     * Set LineNameSpace value
     * @param string $lineNameSpace
     * @return \StructType\DataNameSpacesStructure
     */
    public function setLineNameSpace($lineNameSpace = null)
    {
        // validation for constraint: string
        if (!is_null($lineNameSpace) && !is_string($lineNameSpace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineNameSpace)), __LINE__);
        }
        $this->LineNameSpace = $lineNameSpace;
        return $this;
    }
    /**
     * Get ProductCategoryNameSpace value
     * @return string|null
     */
    public function getProductCategoryNameSpace()
    {
        return $this->ProductCategoryNameSpace;
    }
    /**
     * Set ProductCategoryNameSpace value
     * @param string $productCategoryNameSpace
     * @return \StructType\DataNameSpacesStructure
     */
    public function setProductCategoryNameSpace($productCategoryNameSpace = null)
    {
        // validation for constraint: string
        if (!is_null($productCategoryNameSpace) && !is_string($productCategoryNameSpace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCategoryNameSpace)), __LINE__);
        }
        $this->ProductCategoryNameSpace = $productCategoryNameSpace;
        return $this;
    }
    /**
     * Get ServiceFeatureNameSpace value
     * @return string|null
     */
    public function getServiceFeatureNameSpace()
    {
        return $this->ServiceFeatureNameSpace;
    }
    /**
     * Set ServiceFeatureNameSpace value
     * @param string $serviceFeatureNameSpace
     * @return \StructType\DataNameSpacesStructure
     */
    public function setServiceFeatureNameSpace($serviceFeatureNameSpace = null)
    {
        // validation for constraint: string
        if (!is_null($serviceFeatureNameSpace) && !is_string($serviceFeatureNameSpace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceFeatureNameSpace)), __LINE__);
        }
        $this->ServiceFeatureNameSpace = $serviceFeatureNameSpace;
        return $this;
    }
    /**
     * Get VehicleFeatureNameSpace value
     * @return string|null
     */
    public function getVehicleFeatureNameSpace()
    {
        return $this->VehicleFeatureNameSpace;
    }
    /**
     * Set VehicleFeatureNameSpace value
     * @param string $vehicleFeatureNameSpace
     * @return \StructType\DataNameSpacesStructure
     */
    public function setVehicleFeatureNameSpace($vehicleFeatureNameSpace = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleFeatureNameSpace) && !is_string($vehicleFeatureNameSpace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleFeatureNameSpace)), __LINE__);
        }
        $this->VehicleFeatureNameSpace = $vehicleFeatureNameSpace;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DataNameSpacesStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
