<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsumerResponseEndpointStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Unique reference to this response created by Consumer. May be used to reference the request in subsequent interactions. Used by WSDL. | If request has been proxied by an intermediate aggregating system , tracking information
 * relating to the original requestor. This allows the aggregation to be stateless. +SIRI 2.0
 * @subpackage Structs
 */
class ConsumerResponseEndpointStructure extends ResponseStructure
{
    /**
     * The ConsumerRef
     * @var \StructType\ParticipantRefStructure
     */
    public $ConsumerRef;
    /**
     * The RequestMessageRef
     * @var \StructType\MessageRefStructure
     */
    public $RequestMessageRef;
    /**
     * The DelegatorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $DelegatorAddress;
    /**
     * The DelegatorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $DelegatorRef;
    /**
     * Constructor method for ConsumerResponseEndpointStructure
     * @uses ConsumerResponseEndpointStructure::setConsumerRef()
     * @uses ConsumerResponseEndpointStructure::setRequestMessageRef()
     * @uses ConsumerResponseEndpointStructure::setDelegatorAddress()
     * @uses ConsumerResponseEndpointStructure::setDelegatorRef()
     * @param \StructType\ParticipantRefStructure $consumerRef
     * @param \StructType\MessageRefStructure $requestMessageRef
     * @param string $delegatorAddress
     * @param \StructType\ParticipantRefStructure $delegatorRef
     */
    public function __construct(\StructType\ParticipantRefStructure $consumerRef = null, \StructType\MessageRefStructure $requestMessageRef = null, $delegatorAddress = null, \StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this
            ->setConsumerRef($consumerRef)
            ->setRequestMessageRef($requestMessageRef)
            ->setDelegatorAddress($delegatorAddress)
            ->setDelegatorRef($delegatorRef);
    }
    /**
     * Get ConsumerRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getConsumerRef()
    {
        return $this->ConsumerRef;
    }
    /**
     * Set ConsumerRef value
     * @param \StructType\ParticipantRefStructure $consumerRef
     * @return \StructType\ConsumerResponseEndpointStructure
     */
    public function setConsumerRef(\StructType\ParticipantRefStructure $consumerRef = null)
    {
        $this->ConsumerRef = $consumerRef;
        return $this;
    }
    /**
     * Get RequestMessageRef value
     * @return \StructType\MessageRefStructure|null
     */
    public function getRequestMessageRef()
    {
        return $this->RequestMessageRef;
    }
    /**
     * Set RequestMessageRef value
     * @param \StructType\MessageRefStructure $requestMessageRef
     * @return \StructType\ConsumerResponseEndpointStructure
     */
    public function setRequestMessageRef(\StructType\MessageRefStructure $requestMessageRef = null)
    {
        $this->RequestMessageRef = $requestMessageRef;
        return $this;
    }
    /**
     * Get DelegatorAddress value
     * @return string|null
     */
    public function getDelegatorAddress()
    {
        return $this->DelegatorAddress;
    }
    /**
     * Set DelegatorAddress value
     * @param string $delegatorAddress
     * @return \StructType\ConsumerResponseEndpointStructure
     */
    public function setDelegatorAddress($delegatorAddress = null)
    {
        // validation for constraint: string
        if (!is_null($delegatorAddress) && !is_string($delegatorAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delegatorAddress)), __LINE__);
        }
        $this->DelegatorAddress = $delegatorAddress;
        return $this;
    }
    /**
     * Get DelegatorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getDelegatorRef()
    {
        return $this->DelegatorRef;
    }
    /**
     * Set DelegatorRef value
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @return \StructType\ConsumerResponseEndpointStructure
     */
    public function setDelegatorRef(\StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this->DelegatorRef = $delegatorRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConsumerResponseEndpointStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
