<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsumerRequestEndpointStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Unique reference to this request, created by Consumer. May be used to reference the request in subsequent interactions. Used by WSDL. | If request has been proxied by an intermediate aggregating system , tracking information
 * relating to the original requestor. This allows the aggregation to be stateless. +SIRI 2.0
 * @subpackage Structs
 */
class ConsumerRequestEndpointStructure extends AuthenticatedRequestStructure
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $Address;
    /**
     * The ConsumerRef
     * @var \StructType\ParticipantRefStructure
     */
    public $ConsumerRef;
    /**
     * The MessageIdentifier
     * @var \StructType\MessageQualifierStructure
     */
    public $MessageIdentifier;
    /**
     * The DelegatorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $DelegatorAddress;
    /**
     * The DelegatorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $DelegatorRef;
    /**
     * Constructor method for ConsumerRequestEndpointStructure
     * @uses ConsumerRequestEndpointStructure::setAddress()
     * @uses ConsumerRequestEndpointStructure::setConsumerRef()
     * @uses ConsumerRequestEndpointStructure::setMessageIdentifier()
     * @uses ConsumerRequestEndpointStructure::setDelegatorAddress()
     * @uses ConsumerRequestEndpointStructure::setDelegatorRef()
     * @param string $address
     * @param \StructType\ParticipantRefStructure $consumerRef
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     * @param string $delegatorAddress
     * @param \StructType\ParticipantRefStructure $delegatorRef
     */
    public function __construct($address = null, \StructType\ParticipantRefStructure $consumerRef = null, \StructType\MessageQualifierStructure $messageIdentifier = null, $delegatorAddress = null, \StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this
            ->setAddress($address)
            ->setConsumerRef($consumerRef)
            ->setMessageIdentifier($messageIdentifier)
            ->setDelegatorAddress($delegatorAddress)
            ->setDelegatorRef($delegatorRef);
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\ConsumerRequestEndpointStructure
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ConsumerRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getConsumerRef()
    {
        return $this->ConsumerRef;
    }
    /**
     * Set ConsumerRef value
     * @param \StructType\ParticipantRefStructure $consumerRef
     * @return \StructType\ConsumerRequestEndpointStructure
     */
    public function setConsumerRef(\StructType\ParticipantRefStructure $consumerRef = null)
    {
        $this->ConsumerRef = $consumerRef;
        return $this;
    }
    /**
     * Get MessageIdentifier value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getMessageIdentifier()
    {
        return $this->MessageIdentifier;
    }
    /**
     * Set MessageIdentifier value
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     * @return \StructType\ConsumerRequestEndpointStructure
     */
    public function setMessageIdentifier(\StructType\MessageQualifierStructure $messageIdentifier = null)
    {
        $this->MessageIdentifier = $messageIdentifier;
        return $this;
    }
    /**
     * Get DelegatorAddress value
     * @return string|null
     */
    public function getDelegatorAddress()
    {
        return $this->DelegatorAddress;
    }
    /**
     * Set DelegatorAddress value
     * @param string $delegatorAddress
     * @return \StructType\ConsumerRequestEndpointStructure
     */
    public function setDelegatorAddress($delegatorAddress = null)
    {
        // validation for constraint: string
        if (!is_null($delegatorAddress) && !is_string($delegatorAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delegatorAddress)), __LINE__);
        }
        $this->DelegatorAddress = $delegatorAddress;
        return $this;
    }
    /**
     * Get DelegatorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getDelegatorRef()
    {
        return $this->DelegatorRef;
    }
    /**
     * Set DelegatorRef value
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @return \StructType\ConsumerRequestEndpointStructure
     */
    public function setDelegatorRef(\StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this->DelegatorRef = $delegatorRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConsumerRequestEndpointStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
