<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Conditions StructType
 * @subpackage Structs
 */
class Conditions extends TrafficElement
{
    /**
     * The drivingConditionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $drivingConditionType;
    /**
     * The conditionsExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $conditionsExtension;
    /**
     * Constructor method for Conditions
     * @uses Conditions::setDrivingConditionType()
     * @uses Conditions::setConditionsExtension()
     * @param string $drivingConditionType
     * @param \StructType\ExtensionType $conditionsExtension
     */
    public function __construct($drivingConditionType = null, \StructType\ExtensionType $conditionsExtension = null)
    {
        $this
            ->setDrivingConditionType($drivingConditionType)
            ->setConditionsExtension($conditionsExtension);
    }
    /**
     * Get drivingConditionType value
     * @return string|null
     */
    public function getDrivingConditionType()
    {
        return $this->drivingConditionType;
    }
    /**
     * Set drivingConditionType value
     * @uses \EnumType\DrivingConditionTypeEnum::valueIsValid()
     * @uses \EnumType\DrivingConditionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $drivingConditionType
     * @return \StructType\Conditions
     */
    public function setDrivingConditionType($drivingConditionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DrivingConditionTypeEnum::valueIsValid($drivingConditionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $drivingConditionType, implode(', ', \EnumType\DrivingConditionTypeEnum::getValidValues())), __LINE__);
        }
        $this->drivingConditionType = $drivingConditionType;
        return $this;
    }
    /**
     * Get conditionsExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getConditionsExtension()
    {
        return $this->conditionsExtension;
    }
    /**
     * Set conditionsExtension value
     * @param \StructType\ExtensionType $conditionsExtension
     * @return \StructType\Conditions
     */
    public function setConditionsExtension(\StructType\ExtensionType $conditionsExtension = null)
    {
        $this->conditionsExtension = $conditionsExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Conditions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
