<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CatalogueReference StructType
 * @subpackage Structs
 */
class CatalogueReference extends AbstractStructBase
{
    /**
     * The keyCatalogueReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $keyCatalogueReference;
    /**
     * The catalogueReferenceExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $catalogueReferenceExtension;
    /**
     * Constructor method for CatalogueReference
     * @uses CatalogueReference::setKeyCatalogueReference()
     * @uses CatalogueReference::setCatalogueReferenceExtension()
     * @param string $keyCatalogueReference
     * @param \StructType\ExtensionType $catalogueReferenceExtension
     */
    public function __construct($keyCatalogueReference = null, \StructType\ExtensionType $catalogueReferenceExtension = null)
    {
        $this
            ->setKeyCatalogueReference($keyCatalogueReference)
            ->setCatalogueReferenceExtension($catalogueReferenceExtension);
    }
    /**
     * Get keyCatalogueReference value
     * @return string
     */
    public function getKeyCatalogueReference()
    {
        return $this->keyCatalogueReference;
    }
    /**
     * Set keyCatalogueReference value
     * @param string $keyCatalogueReference
     * @return \StructType\CatalogueReference
     */
    public function setKeyCatalogueReference($keyCatalogueReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($keyCatalogueReference) && strlen($keyCatalogueReference) > 1024) || (is_array($keyCatalogueReference) && count($keyCatalogueReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($keyCatalogueReference) ? strlen($keyCatalogueReference) : count($keyCatalogueReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($keyCatalogueReference) && !is_string($keyCatalogueReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyCatalogueReference)), __LINE__);
        }
        $this->keyCatalogueReference = $keyCatalogueReference;
        return $this;
    }
    /**
     * Get catalogueReferenceExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getCatalogueReferenceExtension()
    {
        return $this->catalogueReferenceExtension;
    }
    /**
     * Set catalogueReferenceExtension value
     * @param \StructType\ExtensionType $catalogueReferenceExtension
     * @return \StructType\CatalogueReference
     */
    public function setCatalogueReferenceExtension(\StructType\ExtensionType $catalogueReferenceExtension = null)
    {
        $this->catalogueReferenceExtension = $catalogueReferenceExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CatalogueReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
