<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarParks StructType
 * @subpackage Structs
 */
class CarParks extends NonRoadEventInformation
{
    /**
     * The carParkIdentity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 1024
     * @var string
     */
    public $carParkIdentity;
    /**
     * The carParkConfiguration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $carParkConfiguration;
    /**
     * The carParkOccupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $carParkOccupancy;
    /**
     * The carParkStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $carParkStatus;
    /**
     * The exitRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $exitRate;
    /**
     * The fillRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $fillRate;
    /**
     * The numberOfVacantParkingSpaces
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $numberOfVacantParkingSpaces;
    /**
     * The occupiedSpaces
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $occupiedSpaces;
    /**
     * The queuingTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $queuingTime;
    /**
     * The totalCapacity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $totalCapacity;
    /**
     * The carParksExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $carParksExtension;
    /**
     * Constructor method for CarParks
     * @uses CarParks::setCarParkIdentity()
     * @uses CarParks::setCarParkConfiguration()
     * @uses CarParks::setCarParkOccupancy()
     * @uses CarParks::setCarParkStatus()
     * @uses CarParks::setExitRate()
     * @uses CarParks::setFillRate()
     * @uses CarParks::setNumberOfVacantParkingSpaces()
     * @uses CarParks::setOccupiedSpaces()
     * @uses CarParks::setQueuingTime()
     * @uses CarParks::setTotalCapacity()
     * @uses CarParks::setCarParksExtension()
     * @param string $carParkIdentity
     * @param string $carParkConfiguration
     * @param float $carParkOccupancy
     * @param string $carParkStatus
     * @param int $exitRate
     * @param int $fillRate
     * @param int $numberOfVacantParkingSpaces
     * @param int $occupiedSpaces
     * @param float $queuingTime
     * @param int $totalCapacity
     * @param \StructType\ExtensionType $carParksExtension
     */
    public function __construct($carParkIdentity = null, $carParkConfiguration = null, $carParkOccupancy = null, $carParkStatus = null, $exitRate = null, $fillRate = null, $numberOfVacantParkingSpaces = null, $occupiedSpaces = null, $queuingTime = null, $totalCapacity = null, \StructType\ExtensionType $carParksExtension = null)
    {
        $this
            ->setCarParkIdentity($carParkIdentity)
            ->setCarParkConfiguration($carParkConfiguration)
            ->setCarParkOccupancy($carParkOccupancy)
            ->setCarParkStatus($carParkStatus)
            ->setExitRate($exitRate)
            ->setFillRate($fillRate)
            ->setNumberOfVacantParkingSpaces($numberOfVacantParkingSpaces)
            ->setOccupiedSpaces($occupiedSpaces)
            ->setQueuingTime($queuingTime)
            ->setTotalCapacity($totalCapacity)
            ->setCarParksExtension($carParksExtension);
    }
    /**
     * Get carParkIdentity value
     * @return string
     */
    public function getCarParkIdentity()
    {
        return $this->carParkIdentity;
    }
    /**
     * Set carParkIdentity value
     * @param string $carParkIdentity
     * @return \StructType\CarParks
     */
    public function setCarParkIdentity($carParkIdentity = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($carParkIdentity) && strlen($carParkIdentity) > 1024) || (is_array($carParkIdentity) && count($carParkIdentity) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($carParkIdentity) ? strlen($carParkIdentity) : count($carParkIdentity)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($carParkIdentity) && !is_string($carParkIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carParkIdentity)), __LINE__);
        }
        $this->carParkIdentity = $carParkIdentity;
        return $this;
    }
    /**
     * Get carParkConfiguration value
     * @return string|null
     */
    public function getCarParkConfiguration()
    {
        return $this->carParkConfiguration;
    }
    /**
     * Set carParkConfiguration value
     * @uses \EnumType\CarParkConfigurationEnum::valueIsValid()
     * @uses \EnumType\CarParkConfigurationEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carParkConfiguration
     * @return \StructType\CarParks
     */
    public function setCarParkConfiguration($carParkConfiguration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CarParkConfigurationEnum::valueIsValid($carParkConfiguration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $carParkConfiguration, implode(', ', \EnumType\CarParkConfigurationEnum::getValidValues())), __LINE__);
        }
        $this->carParkConfiguration = $carParkConfiguration;
        return $this;
    }
    /**
     * Get carParkOccupancy value
     * @return float|null
     */
    public function getCarParkOccupancy()
    {
        return $this->carParkOccupancy;
    }
    /**
     * Set carParkOccupancy value
     * @param float $carParkOccupancy
     * @return \StructType\CarParks
     */
    public function setCarParkOccupancy($carParkOccupancy = null)
    {
        $this->carParkOccupancy = $carParkOccupancy;
        return $this;
    }
    /**
     * Get carParkStatus value
     * @return string|null
     */
    public function getCarParkStatus()
    {
        return $this->carParkStatus;
    }
    /**
     * Set carParkStatus value
     * @uses \EnumType\CarParkStatusEnum::valueIsValid()
     * @uses \EnumType\CarParkStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carParkStatus
     * @return \StructType\CarParks
     */
    public function setCarParkStatus($carParkStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CarParkStatusEnum::valueIsValid($carParkStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $carParkStatus, implode(', ', \EnumType\CarParkStatusEnum::getValidValues())), __LINE__);
        }
        $this->carParkStatus = $carParkStatus;
        return $this;
    }
    /**
     * Get exitRate value
     * @return int|null
     */
    public function getExitRate()
    {
        return $this->exitRate;
    }
    /**
     * Set exitRate value
     * @param int $exitRate
     * @return \StructType\CarParks
     */
    public function setExitRate($exitRate = null)
    {
        // validation for constraint: int
        if (!is_null($exitRate) && !is_numeric($exitRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($exitRate)), __LINE__);
        }
        $this->exitRate = $exitRate;
        return $this;
    }
    /**
     * Get fillRate value
     * @return int|null
     */
    public function getFillRate()
    {
        return $this->fillRate;
    }
    /**
     * Set fillRate value
     * @param int $fillRate
     * @return \StructType\CarParks
     */
    public function setFillRate($fillRate = null)
    {
        // validation for constraint: int
        if (!is_null($fillRate) && !is_numeric($fillRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fillRate)), __LINE__);
        }
        $this->fillRate = $fillRate;
        return $this;
    }
    /**
     * Get numberOfVacantParkingSpaces value
     * @return int|null
     */
    public function getNumberOfVacantParkingSpaces()
    {
        return $this->numberOfVacantParkingSpaces;
    }
    /**
     * Set numberOfVacantParkingSpaces value
     * @param int $numberOfVacantParkingSpaces
     * @return \StructType\CarParks
     */
    public function setNumberOfVacantParkingSpaces($numberOfVacantParkingSpaces = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfVacantParkingSpaces) && !is_numeric($numberOfVacantParkingSpaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfVacantParkingSpaces)), __LINE__);
        }
        $this->numberOfVacantParkingSpaces = $numberOfVacantParkingSpaces;
        return $this;
    }
    /**
     * Get occupiedSpaces value
     * @return int|null
     */
    public function getOccupiedSpaces()
    {
        return $this->occupiedSpaces;
    }
    /**
     * Set occupiedSpaces value
     * @param int $occupiedSpaces
     * @return \StructType\CarParks
     */
    public function setOccupiedSpaces($occupiedSpaces = null)
    {
        // validation for constraint: int
        if (!is_null($occupiedSpaces) && !is_numeric($occupiedSpaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($occupiedSpaces)), __LINE__);
        }
        $this->occupiedSpaces = $occupiedSpaces;
        return $this;
    }
    /**
     * Get queuingTime value
     * @return float|null
     */
    public function getQueuingTime()
    {
        return $this->queuingTime;
    }
    /**
     * Set queuingTime value
     * @param float $queuingTime
     * @return \StructType\CarParks
     */
    public function setQueuingTime($queuingTime = null)
    {
        $this->queuingTime = $queuingTime;
        return $this;
    }
    /**
     * Get totalCapacity value
     * @return int|null
     */
    public function getTotalCapacity()
    {
        return $this->totalCapacity;
    }
    /**
     * Set totalCapacity value
     * @param int $totalCapacity
     * @return \StructType\CarParks
     */
    public function setTotalCapacity($totalCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($totalCapacity) && !is_numeric($totalCapacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalCapacity)), __LINE__);
        }
        $this->totalCapacity = $totalCapacity;
        return $this;
    }
    /**
     * Get carParksExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getCarParksExtension()
    {
        return $this->carParksExtension;
    }
    /**
     * Set carParksExtension value
     * @param \StructType\ExtensionType $carParksExtension
     * @return \StructType\CarParks
     */
    public function setCarParksExtension(\StructType\ExtensionType $carParksExtension = null)
    {
        $this->carParksExtension = $carParksExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CarParks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
