<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CapabilityRequestPolicyStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Common Request Policy capabilities. | Default geospatial Coordinates used by service.
 * @subpackage Structs
 */
class CapabilityRequestPolicyStructure extends AbstractStructBase
{
    /**
     * The NationalLanguage
     * Meta informations extracted from the WSDL
     * - documentation: National languages supported by service.
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $NationalLanguage;
    /**
     * The Translations
     * Meta informations extracted from the WSDL
     * - documentation: Whether producer can provide multiple translations of NL text elements +SIRI 2.0
     * - minOccurs: 0
     * @var bool
     */
    public $Translations;
    /**
     * The GmlCoordinateFormat
     * Meta informations extracted from the WSDL
     * - documentation: Name of GML Coordinate format used for Geospatial points in responses. | Type for coordinate reference system.
     * @var string
     */
    public $GmlCoordinateFormat;
    /**
     * The WgsDecimalDegrees
     * Meta informations extracted from the WSDL
     * - documentation: Geospatial coordinates are given as Wgs 84 Latiude and longitude, decimial degrees of arc.
     * @var string
     */
    public $WgsDecimalDegrees;
    /**
     * Constructor method for CapabilityRequestPolicyStructure
     * @uses CapabilityRequestPolicyStructure::setNationalLanguage()
     * @uses CapabilityRequestPolicyStructure::setTranslations()
     * @uses CapabilityRequestPolicyStructure::setGmlCoordinateFormat()
     * @uses CapabilityRequestPolicyStructure::setWgsDecimalDegrees()
     * @param string[] $nationalLanguage
     * @param bool $translations
     * @param string $gmlCoordinateFormat
     * @param string $wgsDecimalDegrees
     */
    public function __construct(array $nationalLanguage = array(), $translations = null, $gmlCoordinateFormat = null, $wgsDecimalDegrees = null)
    {
        $this
            ->setNationalLanguage($nationalLanguage)
            ->setTranslations($translations)
            ->setGmlCoordinateFormat($gmlCoordinateFormat)
            ->setWgsDecimalDegrees($wgsDecimalDegrees);
    }
    /**
     * Get NationalLanguage value
     * @return string[]|null
     */
    public function getNationalLanguage()
    {
        return $this->NationalLanguage;
    }
    /**
     * Set NationalLanguage value
     * @throws \InvalidArgumentException
     * @param string[] $nationalLanguage
     * @return \StructType\CapabilityRequestPolicyStructure
     */
    public function setNationalLanguage(array $nationalLanguage = array())
    {
        foreach ($nationalLanguage as $capabilityRequestPolicyStructureNationalLanguageItem) {
            // validation for constraint: itemType
            if (!is_string($capabilityRequestPolicyStructureNationalLanguageItem)) {
                throw new \InvalidArgumentException(sprintf('The NationalLanguage property can only contain items of language, "%s" given', is_object($capabilityRequestPolicyStructureNationalLanguageItem) ? get_class($capabilityRequestPolicyStructureNationalLanguageItem) : gettype($capabilityRequestPolicyStructureNationalLanguageItem)), __LINE__);
            }
        }
        $this->NationalLanguage = $nationalLanguage;
        return $this;
    }
    /**
     * Add item to NationalLanguage value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CapabilityRequestPolicyStructure
     */
    public function addToNationalLanguage($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The NationalLanguage property can only contain items of language, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NationalLanguage[] = $item;
        return $this;
    }
    /**
     * Get Translations value
     * @return bool|null
     */
    public function getTranslations()
    {
        return $this->Translations;
    }
    /**
     * Set Translations value
     * @param bool $translations
     * @return \StructType\CapabilityRequestPolicyStructure
     */
    public function setTranslations($translations = null)
    {
        // validation for constraint: boolean
        if (!is_null($translations) && !is_bool($translations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($translations)), __LINE__);
        }
        $this->Translations = $translations;
        return $this;
    }
    /**
     * Get GmlCoordinateFormat value
     * @return string|null
     */
    public function getGmlCoordinateFormat()
    {
        return $this->GmlCoordinateFormat;
    }
    /**
     * Set GmlCoordinateFormat value
     * @param string $gmlCoordinateFormat
     * @return \StructType\CapabilityRequestPolicyStructure
     */
    public function setGmlCoordinateFormat($gmlCoordinateFormat = null)
    {
        // validation for constraint: string
        if (!is_null($gmlCoordinateFormat) && !is_string($gmlCoordinateFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gmlCoordinateFormat)), __LINE__);
        }
        $this->GmlCoordinateFormat = $gmlCoordinateFormat;
        return $this;
    }
    /**
     * Get WgsDecimalDegrees value
     * @return string|null
     */
    public function getWgsDecimalDegrees()
    {
        return $this->WgsDecimalDegrees;
    }
    /**
     * Set WgsDecimalDegrees value
     * @uses \EnumType\EmptyType::valueIsValid()
     * @uses \EnumType\EmptyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $wgsDecimalDegrees
     * @return \StructType\CapabilityRequestPolicyStructure
     */
    public function setWgsDecimalDegrees($wgsDecimalDegrees = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmptyType::valueIsValid($wgsDecimalDegrees)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $wgsDecimalDegrees, implode(', ', \EnumType\EmptyType::getValidValues())), __LINE__);
        }
        $this->WgsDecimalDegrees = $wgsDecimalDegrees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CapabilityRequestPolicyStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
