<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Calls StructType
 * Meta informations extracted from the WSDL
 * - documentation: CALLs making up VEHICLE JOURNEY [equivalent to TPEG pti15 3 stop, 15_5 not-stopping, 15-6 temporary stop route_description_type]
 * @subpackage Structs
 */
class Calls extends AbstractStructBase
{
    /**
     * The Call
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AffectedCallStructure[]
     */
    public $Call;
    /**
     * Constructor method for Calls
     * @uses Calls::setCall()
     * @param \StructType\AffectedCallStructure[] $call
     */
    public function __construct(array $call = array())
    {
        $this
            ->setCall($call);
    }
    /**
     * Get Call value
     * @return \StructType\AffectedCallStructure[]|null
     */
    public function getCall()
    {
        return $this->Call;
    }
    /**
     * Set Call value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedCallStructure[] $call
     * @return \StructType\Calls
     */
    public function setCall(array $call = array())
    {
        foreach ($call as $callsCallItem) {
            // validation for constraint: itemType
            if (!$callsCallItem instanceof \StructType\AffectedCallStructure) {
                throw new \InvalidArgumentException(sprintf('The Call property can only contain items of \StructType\AffectedCallStructure, "%s" given', is_object($callsCallItem) ? get_class($callsCallItem) : gettype($callsCallItem)), __LINE__);
            }
        }
        $this->Call = $call;
        return $this;
    }
    /**
     * Add item to Call value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedCallStructure $item
     * @return \StructType\Calls
     */
    public function addToCall(\StructType\AffectedCallStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedCallStructure) {
            throw new \InvalidArgumentException(sprintf('The Call property can only contain items of \StructType\AffectedCallStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Call[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Calls
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
