<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoundingBoxStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Defines a bounding box using two corner points. GML terminology. +SIRI v2.0
 * @subpackage Structs
 */
class BoundingBoxStructure extends AbstractStructBase
{
    /**
     * The UpperLeft
     * Meta informations extracted from the WSDL
     * - documentation: A geospatial point. Upper Left corner..
     * @var \StructType\LocationStructure
     */
    public $UpperLeft;
    /**
     * The LowerRight
     * Meta informations extracted from the WSDL
     * - documentation: A geospatial point. Lower right corner..
     * @var \StructType\LocationStructure
     */
    public $LowerRight;
    /**
     * Constructor method for BoundingBoxStructure
     * @uses BoundingBoxStructure::setUpperLeft()
     * @uses BoundingBoxStructure::setLowerRight()
     * @param \StructType\LocationStructure $upperLeft
     * @param \StructType\LocationStructure $lowerRight
     */
    public function __construct(\StructType\LocationStructure $upperLeft = null, \StructType\LocationStructure $lowerRight = null)
    {
        $this
            ->setUpperLeft($upperLeft)
            ->setLowerRight($lowerRight);
    }
    /**
     * Get UpperLeft value
     * @return \StructType\LocationStructure|null
     */
    public function getUpperLeft()
    {
        return $this->UpperLeft;
    }
    /**
     * Set UpperLeft value
     * @param \StructType\LocationStructure $upperLeft
     * @return \StructType\BoundingBoxStructure
     */
    public function setUpperLeft(\StructType\LocationStructure $upperLeft = null)
    {
        $this->UpperLeft = $upperLeft;
        return $this;
    }
    /**
     * Get LowerRight value
     * @return \StructType\LocationStructure|null
     */
    public function getLowerRight()
    {
        return $this->LowerRight;
    }
    /**
     * Set LowerRight value
     * @param \StructType\LocationStructure $lowerRight
     * @return \StructType\BoundingBoxStructure
     */
    public function setLowerRight(\StructType\LocationStructure $lowerRight = null)
    {
        $this->LowerRight = $lowerRight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BoundingBoxStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
