<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlockingStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for blocking.
 * @subpackage Structs
 */
class BlockingStructure extends AbstractStructBase
{
    /**
     * The JourneyPlanner
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether information about parts of the network identified by Affects should be blocked from computation made by a Journey Planner that has a real-tiem feed of the SITUATIONs. Default is 'false'; do not suppress.
     * - minOccurs: 0
     * @var bool
     */
    public $JourneyPlanner;
    /**
     * The RealTime
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Whether information about parts of the network identified by Affects should be blocked from real-time departureinfo systems. Default is 'false'; do not suppress.
     * - minOccurs: 0
     * @var bool
     */
    public $RealTime;
    /**
     * Constructor method for BlockingStructure
     * @uses BlockingStructure::setJourneyPlanner()
     * @uses BlockingStructure::setRealTime()
     * @param bool $journeyPlanner
     * @param bool $realTime
     */
    public function __construct($journeyPlanner = false, $realTime = false)
    {
        $this
            ->setJourneyPlanner($journeyPlanner)
            ->setRealTime($realTime);
    }
    /**
     * Get JourneyPlanner value
     * @return bool|null
     */
    public function getJourneyPlanner()
    {
        return $this->JourneyPlanner;
    }
    /**
     * Set JourneyPlanner value
     * @param bool $journeyPlanner
     * @return \StructType\BlockingStructure
     */
    public function setJourneyPlanner($journeyPlanner = false)
    {
        // validation for constraint: boolean
        if (!is_null($journeyPlanner) && !is_bool($journeyPlanner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($journeyPlanner)), __LINE__);
        }
        $this->JourneyPlanner = $journeyPlanner;
        return $this;
    }
    /**
     * Get RealTime value
     * @return bool|null
     */
    public function getRealTime()
    {
        return $this->RealTime;
    }
    /**
     * Set RealTime value
     * @param bool $realTime
     * @return \StructType\BlockingStructure
     */
    public function setRealTime($realTime = false)
    {
        // validation for constraint: boolean
        if (!is_null($realTime) && !is_bool($realTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($realTime)), __LINE__);
        }
        $this->RealTime = $realTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BlockingStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
