<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnnotatedLineStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Summary information about a LINE type.
 * @subpackage Structs
 */
class AnnotatedLineStructure extends AbstractStructBase
{
    /**
     * The LineRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of LINE.
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The LineName
     * Meta informations extracted from the WSDL
     * - documentation: Name of LINE. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $LineName;
    /**
     * The Monitored
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether the LINE has real-time info. Default is 'true'.
     * @var bool
     */
    public $Monitored;
    /**
     * The Destinations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Destinations
     */
    public $Destinations;
    /**
     * The Directions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Directions
     */
    public $Directions;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AnnotatedLineStructure
     * @uses AnnotatedLineStructure::setLineRef()
     * @uses AnnotatedLineStructure::setLineName()
     * @uses AnnotatedLineStructure::setMonitored()
     * @uses AnnotatedLineStructure::setDestinations()
     * @uses AnnotatedLineStructure::setDirections()
     * @uses AnnotatedLineStructure::setExtensions()
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\NaturalLanguageStringStructure[] $lineName
     * @param bool $monitored
     * @param \StructType\Destinations $destinations
     * @param \StructType\Directions $directions
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\LineRefStructure $lineRef = null, array $lineName = array(), $monitored = true, \StructType\Destinations $destinations = null, \StructType\Directions $directions = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setLineRef($lineRef)
            ->setLineName($lineName)
            ->setMonitored($monitored)
            ->setDestinations($destinations)
            ->setDirections($directions)
            ->setExtensions($extensions);
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\AnnotatedLineStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get LineName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getLineName()
    {
        return $this->LineName;
    }
    /**
     * Set LineName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $lineName
     * @return \StructType\AnnotatedLineStructure
     */
    public function setLineName(array $lineName = array())
    {
        foreach ($lineName as $annotatedLineStructureLineNameItem) {
            // validation for constraint: itemType
            if (!$annotatedLineStructureLineNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The LineName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($annotatedLineStructureLineNameItem) ? get_class($annotatedLineStructureLineNameItem) : gettype($annotatedLineStructureLineNameItem)), __LINE__);
            }
        }
        $this->LineName = $lineName;
        return $this;
    }
    /**
     * Add item to LineName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AnnotatedLineStructure
     */
    public function addToLineName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The LineName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LineName[] = $item;
        return $this;
    }
    /**
     * Get Monitored value
     * @return bool|null
     */
    public function getMonitored()
    {
        return $this->Monitored;
    }
    /**
     * Set Monitored value
     * @param bool $monitored
     * @return \StructType\AnnotatedLineStructure
     */
    public function setMonitored($monitored = true)
    {
        // validation for constraint: boolean
        if (!is_null($monitored) && !is_bool($monitored)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($monitored)), __LINE__);
        }
        $this->Monitored = $monitored;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \StructType\Destinations|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \StructType\Destinations $destinations
     * @return \StructType\AnnotatedLineStructure
     */
    public function setDestinations(\StructType\Destinations $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get Directions value
     * @return \StructType\Directions|null
     */
    public function getDirections()
    {
        return $this->Directions;
    }
    /**
     * Set Directions value
     * @param \StructType\Directions $directions
     * @return \StructType\AnnotatedLineStructure
     */
    public function setDirections(\StructType\Directions $directions = null)
    {
        $this->Directions = $directions;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AnnotatedLineStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnnotatedLineStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
