<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnnotatedFacilityStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Summary information about Facility. Used in DISCOVERY used
 * @subpackage Structs
 */
class AnnotatedFacilityStructure extends AbstractStructBase
{
    /**
     * The FacilityRef
     * Meta informations extracted from the WSDL
     * - ref: FacilityRef
     * @var \StructType\FacilityRefStructure
     */
    public $FacilityRef;
    /**
     * The Monitored
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether real-time data is available for the stop. Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $Monitored;
    /**
     * The Facility
     * Meta informations extracted from the WSDL
     * - documentation: Description of the facility (without its status)
     * - minOccurs: 0
     * @var \StructType\FacilityStructure
     */
    public $Facility;
    /**
     * Constructor method for AnnotatedFacilityStructure
     * @uses AnnotatedFacilityStructure::setFacilityRef()
     * @uses AnnotatedFacilityStructure::setMonitored()
     * @uses AnnotatedFacilityStructure::setFacility()
     * @param \StructType\FacilityRefStructure $facilityRef
     * @param bool $monitored
     * @param \StructType\FacilityStructure $facility
     */
    public function __construct(\StructType\FacilityRefStructure $facilityRef = null, $monitored = true, \StructType\FacilityStructure $facility = null)
    {
        $this
            ->setFacilityRef($facilityRef)
            ->setMonitored($monitored)
            ->setFacility($facility);
    }
    /**
     * Get FacilityRef value
     * @return \StructType\FacilityRefStructure|null
     */
    public function getFacilityRef()
    {
        return $this->FacilityRef;
    }
    /**
     * Set FacilityRef value
     * @param \StructType\FacilityRefStructure $facilityRef
     * @return \StructType\AnnotatedFacilityStructure
     */
    public function setFacilityRef(\StructType\FacilityRefStructure $facilityRef = null)
    {
        $this->FacilityRef = $facilityRef;
        return $this;
    }
    /**
     * Get Monitored value
     * @return bool|null
     */
    public function getMonitored()
    {
        return $this->Monitored;
    }
    /**
     * Set Monitored value
     * @param bool $monitored
     * @return \StructType\AnnotatedFacilityStructure
     */
    public function setMonitored($monitored = true)
    {
        // validation for constraint: boolean
        if (!is_null($monitored) && !is_bool($monitored)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($monitored)), __LINE__);
        }
        $this->Monitored = $monitored;
        return $this;
    }
    /**
     * Get Facility value
     * @return \StructType\FacilityStructure|null
     */
    public function getFacility()
    {
        return $this->Facility;
    }
    /**
     * Set Facility value
     * @param \StructType\FacilityStructure $facility
     * @return \StructType\AnnotatedFacilityStructure
     */
    public function setFacility(\StructType\FacilityStructure $facility = null)
    {
        $this->Facility = $facility;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnnotatedFacilityStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
