<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnnotatedConnectionLinkStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: View of a SCHEDULED CONNECTION LINK description.
 * @subpackage Structs
 */
class AnnotatedConnectionLinkStructure extends AbstractStructBase
{
    /**
     * The ConnectionLinkRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifer of the connection link. DetailLevel=minimum
     * @var \StructType\ConnectionLinkRefStructure
     */
    public $ConnectionLinkRef;
    /**
     * The FeederStopPointRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifer of the feeder's stop. DetailLevel=normal
     * - minOccurs: 0
     * @var \StructType\StopPointRefStructure
     */
    public $FeederStopPointRef;
    /**
     * The DistributorStopPointRef
     * Meta informations extracted from the WSDL
     * - documentation: Identifer of the distributor's stop. DetailLevel=normal
     * - minOccurs: 0
     * @var \StructType\StopPointRefStructure
     */
    public $DistributorStopPointRef;
    /**
     * The Monitored
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether real-time data is available for the connection link. Default is 'true'. DetailLevel=minimum
     * - minOccurs: 0
     * @var bool
     */
    public $Monitored;
    /**
     * The ConnectionLinkName
     * Meta informations extracted from the WSDL
     * - documentation: Name of SCHEDULED CONNECTION LINK. DetailLevel=minimum
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $ConnectionLinkName;
    /**
     * The FeederStopPointName
     * Meta informations extracted from the WSDL
     * - documentation: Name of the feeder's stop. DetailLevel=full
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $FeederStopPointName;
    /**
     * The DistributorStopPointName
     * Meta informations extracted from the WSDL
     * - documentation: Name of the distributor's stop. DetailLevel=full
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $DistributorStopPointName;
    /**
     * The Url
     * Meta informations extracted from the WSDL
     * - documentation: Web page associated with connection link. DetailLevel=full
     * - minOccurs: 0
     * @var string
     */
    public $Url;
    /**
     * Constructor method for AnnotatedConnectionLinkStructure
     * @uses AnnotatedConnectionLinkStructure::setConnectionLinkRef()
     * @uses AnnotatedConnectionLinkStructure::setFeederStopPointRef()
     * @uses AnnotatedConnectionLinkStructure::setDistributorStopPointRef()
     * @uses AnnotatedConnectionLinkStructure::setMonitored()
     * @uses AnnotatedConnectionLinkStructure::setConnectionLinkName()
     * @uses AnnotatedConnectionLinkStructure::setFeederStopPointName()
     * @uses AnnotatedConnectionLinkStructure::setDistributorStopPointName()
     * @uses AnnotatedConnectionLinkStructure::setUrl()
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @param \StructType\StopPointRefStructure $feederStopPointRef
     * @param \StructType\StopPointRefStructure $distributorStopPointRef
     * @param bool $monitored
     * @param \StructType\NaturalLanguageStringStructure[] $connectionLinkName
     * @param \StructType\NaturalLanguageStringStructure[] $feederStopPointName
     * @param \StructType\NaturalLanguageStringStructure[] $distributorStopPointName
     * @param string $url
     */
    public function __construct(\StructType\ConnectionLinkRefStructure $connectionLinkRef = null, \StructType\StopPointRefStructure $feederStopPointRef = null, \StructType\StopPointRefStructure $distributorStopPointRef = null, $monitored = true, array $connectionLinkName = array(), array $feederStopPointName = array(), array $distributorStopPointName = array(), $url = null)
    {
        $this
            ->setConnectionLinkRef($connectionLinkRef)
            ->setFeederStopPointRef($feederStopPointRef)
            ->setDistributorStopPointRef($distributorStopPointRef)
            ->setMonitored($monitored)
            ->setConnectionLinkName($connectionLinkName)
            ->setFeederStopPointName($feederStopPointName)
            ->setDistributorStopPointName($distributorStopPointName)
            ->setUrl($url);
    }
    /**
     * Get ConnectionLinkRef value
     * @return \StructType\ConnectionLinkRefStructure|null
     */
    public function getConnectionLinkRef()
    {
        return $this->ConnectionLinkRef;
    }
    /**
     * Set ConnectionLinkRef value
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @return \StructType\AnnotatedConnectionLinkStructure
     */
    public function setConnectionLinkRef(\StructType\ConnectionLinkRefStructure $connectionLinkRef = null)
    {
        $this->ConnectionLinkRef = $connectionLinkRef;
        return $this;
    }
    /**
     * Get FeederStopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getFeederStopPointRef()
    {
        return $this->FeederStopPointRef;
    }
    /**
     * Set FeederStopPointRef value
     * @param \StructType\StopPointRefStructure $feederStopPointRef
     * @return \StructType\AnnotatedConnectionLinkStructure
     */
    public function setFeederStopPointRef(\StructType\StopPointRefStructure $feederStopPointRef = null)
    {
        $this->FeederStopPointRef = $feederStopPointRef;
        return $this;
    }
    /**
     * Get DistributorStopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getDistributorStopPointRef()
    {
        return $this->DistributorStopPointRef;
    }
    /**
     * Set DistributorStopPointRef value
     * @param \StructType\StopPointRefStructure $distributorStopPointRef
     * @return \StructType\AnnotatedConnectionLinkStructure
     */
    public function setDistributorStopPointRef(\StructType\StopPointRefStructure $distributorStopPointRef = null)
    {
        $this->DistributorStopPointRef = $distributorStopPointRef;
        return $this;
    }
    /**
     * Get Monitored value
     * @return bool|null
     */
    public function getMonitored()
    {
        return $this->Monitored;
    }
    /**
     * Set Monitored value
     * @param bool $monitored
     * @return \StructType\AnnotatedConnectionLinkStructure
     */
    public function setMonitored($monitored = true)
    {
        // validation for constraint: boolean
        if (!is_null($monitored) && !is_bool($monitored)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($monitored)), __LINE__);
        }
        $this->Monitored = $monitored;
        return $this;
    }
    /**
     * Get ConnectionLinkName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getConnectionLinkName()
    {
        return $this->ConnectionLinkName;
    }
    /**
     * Set ConnectionLinkName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $connectionLinkName
     * @return \StructType\AnnotatedConnectionLinkStructure
     */
    public function setConnectionLinkName(array $connectionLinkName = array())
    {
        foreach ($connectionLinkName as $annotatedConnectionLinkStructureConnectionLinkNameItem) {
            // validation for constraint: itemType
            if (!$annotatedConnectionLinkStructureConnectionLinkNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The ConnectionLinkName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($annotatedConnectionLinkStructureConnectionLinkNameItem) ? get_class($annotatedConnectionLinkStructureConnectionLinkNameItem) : gettype($annotatedConnectionLinkStructureConnectionLinkNameItem)), __LINE__);
            }
        }
        $this->ConnectionLinkName = $connectionLinkName;
        return $this;
    }
    /**
     * Add item to ConnectionLinkName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AnnotatedConnectionLinkStructure
     */
    public function addToConnectionLinkName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The ConnectionLinkName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ConnectionLinkName[] = $item;
        return $this;
    }
    /**
     * Get FeederStopPointName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getFeederStopPointName()
    {
        return $this->FeederStopPointName;
    }
    /**
     * Set FeederStopPointName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $feederStopPointName
     * @return \StructType\AnnotatedConnectionLinkStructure
     */
    public function setFeederStopPointName(array $feederStopPointName = array())
    {
        foreach ($feederStopPointName as $annotatedConnectionLinkStructureFeederStopPointNameItem) {
            // validation for constraint: itemType
            if (!$annotatedConnectionLinkStructureFeederStopPointNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The FeederStopPointName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($annotatedConnectionLinkStructureFeederStopPointNameItem) ? get_class($annotatedConnectionLinkStructureFeederStopPointNameItem) : gettype($annotatedConnectionLinkStructureFeederStopPointNameItem)), __LINE__);
            }
        }
        $this->FeederStopPointName = $feederStopPointName;
        return $this;
    }
    /**
     * Add item to FeederStopPointName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AnnotatedConnectionLinkStructure
     */
    public function addToFeederStopPointName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The FeederStopPointName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FeederStopPointName[] = $item;
        return $this;
    }
    /**
     * Get DistributorStopPointName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getDistributorStopPointName()
    {
        return $this->DistributorStopPointName;
    }
    /**
     * Set DistributorStopPointName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $distributorStopPointName
     * @return \StructType\AnnotatedConnectionLinkStructure
     */
    public function setDistributorStopPointName(array $distributorStopPointName = array())
    {
        foreach ($distributorStopPointName as $annotatedConnectionLinkStructureDistributorStopPointNameItem) {
            // validation for constraint: itemType
            if (!$annotatedConnectionLinkStructureDistributorStopPointNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The DistributorStopPointName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($annotatedConnectionLinkStructureDistributorStopPointNameItem) ? get_class($annotatedConnectionLinkStructureDistributorStopPointNameItem) : gettype($annotatedConnectionLinkStructureDistributorStopPointNameItem)), __LINE__);
            }
        }
        $this->DistributorStopPointName = $distributorStopPointName;
        return $this;
    }
    /**
     * Add item to DistributorStopPointName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AnnotatedConnectionLinkStructure
     */
    public function addToDistributorStopPointName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The DistributorStopPointName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DistributorStopPointName[] = $item;
        return $this;
    }
    /**
     * Get Url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->Url;
    }
    /**
     * Set Url value
     * @param string $url
     * @return \StructType\AnnotatedConnectionLinkStructure
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->Url = $url;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnnotatedConnectionLinkStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
