<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectsScopeStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Location model for scope of SITUATION or effect.
 * @subpackage Structs
 */
class AffectsScopeStructure extends AbstractStructBase
{
    /**
     * The AreaOfInterest
     * Meta informations extracted from the WSDL
     * - documentation: Affected overall Geographic scope.
     * - minOccurs: 0
     * @var string
     */
    public $AreaOfInterest;
    /**
     * The Operators
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Operators
     */
    public $Operators;
    /**
     * The Networks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Networks
     */
    public $Networks;
    /**
     * The StopPoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StopPoints
     */
    public $StopPoints;
    /**
     * The StopPlaces
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StopPlaces
     */
    public $StopPlaces;
    /**
     * The Places
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Places
     */
    public $Places;
    /**
     * The VehicleJourneys
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehicleJourneys
     */
    public $VehicleJourneys;
    /**
     * The Vehicles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Vehicles
     */
    public $Vehicles;
    /**
     * The Roads
     * Meta informations extracted from the WSDL
     * - documentation: Roads affected by.
     * - minOccurs: 0
     * @var \StructType\AffectedRoadsStructure
     */
    public $Roads;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectsScopeStructure
     * @uses AffectsScopeStructure::setAreaOfInterest()
     * @uses AffectsScopeStructure::setOperators()
     * @uses AffectsScopeStructure::setNetworks()
     * @uses AffectsScopeStructure::setStopPoints()
     * @uses AffectsScopeStructure::setStopPlaces()
     * @uses AffectsScopeStructure::setPlaces()
     * @uses AffectsScopeStructure::setVehicleJourneys()
     * @uses AffectsScopeStructure::setVehicles()
     * @uses AffectsScopeStructure::setRoads()
     * @uses AffectsScopeStructure::setExtensions()
     * @param string $areaOfInterest
     * @param \StructType\Operators $operators
     * @param \StructType\Networks $networks
     * @param \StructType\StopPoints $stopPoints
     * @param \StructType\StopPlaces $stopPlaces
     * @param \StructType\Places $places
     * @param \StructType\VehicleJourneys $vehicleJourneys
     * @param \StructType\Vehicles $vehicles
     * @param \StructType\AffectedRoadsStructure $roads
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($areaOfInterest = null, \StructType\Operators $operators = null, \StructType\Networks $networks = null, \StructType\StopPoints $stopPoints = null, \StructType\StopPlaces $stopPlaces = null, \StructType\Places $places = null, \StructType\VehicleJourneys $vehicleJourneys = null, \StructType\Vehicles $vehicles = null, \StructType\AffectedRoadsStructure $roads = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setAreaOfInterest($areaOfInterest)
            ->setOperators($operators)
            ->setNetworks($networks)
            ->setStopPoints($stopPoints)
            ->setStopPlaces($stopPlaces)
            ->setPlaces($places)
            ->setVehicleJourneys($vehicleJourneys)
            ->setVehicles($vehicles)
            ->setRoads($roads)
            ->setExtensions($extensions);
    }
    /**
     * Get AreaOfInterest value
     * @return string|null
     */
    public function getAreaOfInterest()
    {
        return $this->AreaOfInterest;
    }
    /**
     * Set AreaOfInterest value
     * @uses \EnumType\AreaOfInterestEnum::valueIsValid()
     * @uses \EnumType\AreaOfInterestEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $areaOfInterest
     * @return \StructType\AffectsScopeStructure
     */
    public function setAreaOfInterest($areaOfInterest = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AreaOfInterestEnum::valueIsValid($areaOfInterest)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $areaOfInterest, implode(', ', \EnumType\AreaOfInterestEnum::getValidValues())), __LINE__);
        }
        $this->AreaOfInterest = $areaOfInterest;
        return $this;
    }
    /**
     * Get Operators value
     * @return \StructType\Operators|null
     */
    public function getOperators()
    {
        return $this->Operators;
    }
    /**
     * Set Operators value
     * @param \StructType\Operators $operators
     * @return \StructType\AffectsScopeStructure
     */
    public function setOperators(\StructType\Operators $operators = null)
    {
        $this->Operators = $operators;
        return $this;
    }
    /**
     * Get Networks value
     * @return \StructType\Networks|null
     */
    public function getNetworks()
    {
        return $this->Networks;
    }
    /**
     * Set Networks value
     * @param \StructType\Networks $networks
     * @return \StructType\AffectsScopeStructure
     */
    public function setNetworks(\StructType\Networks $networks = null)
    {
        $this->Networks = $networks;
        return $this;
    }
    /**
     * Get StopPoints value
     * @return \StructType\StopPoints|null
     */
    public function getStopPoints()
    {
        return $this->StopPoints;
    }
    /**
     * Set StopPoints value
     * @param \StructType\StopPoints $stopPoints
     * @return \StructType\AffectsScopeStructure
     */
    public function setStopPoints(\StructType\StopPoints $stopPoints = null)
    {
        $this->StopPoints = $stopPoints;
        return $this;
    }
    /**
     * Get StopPlaces value
     * @return \StructType\StopPlaces|null
     */
    public function getStopPlaces()
    {
        return $this->StopPlaces;
    }
    /**
     * Set StopPlaces value
     * @param \StructType\StopPlaces $stopPlaces
     * @return \StructType\AffectsScopeStructure
     */
    public function setStopPlaces(\StructType\StopPlaces $stopPlaces = null)
    {
        $this->StopPlaces = $stopPlaces;
        return $this;
    }
    /**
     * Get Places value
     * @return \StructType\Places|null
     */
    public function getPlaces()
    {
        return $this->Places;
    }
    /**
     * Set Places value
     * @param \StructType\Places $places
     * @return \StructType\AffectsScopeStructure
     */
    public function setPlaces(\StructType\Places $places = null)
    {
        $this->Places = $places;
        return $this;
    }
    /**
     * Get VehicleJourneys value
     * @return \StructType\VehicleJourneys|null
     */
    public function getVehicleJourneys()
    {
        return $this->VehicleJourneys;
    }
    /**
     * Set VehicleJourneys value
     * @param \StructType\VehicleJourneys $vehicleJourneys
     * @return \StructType\AffectsScopeStructure
     */
    public function setVehicleJourneys(\StructType\VehicleJourneys $vehicleJourneys = null)
    {
        $this->VehicleJourneys = $vehicleJourneys;
        return $this;
    }
    /**
     * Get Vehicles value
     * @return \StructType\Vehicles|null
     */
    public function getVehicles()
    {
        return $this->Vehicles;
    }
    /**
     * Set Vehicles value
     * @param \StructType\Vehicles $vehicles
     * @return \StructType\AffectsScopeStructure
     */
    public function setVehicles(\StructType\Vehicles $vehicles = null)
    {
        $this->Vehicles = $vehicles;
        return $this;
    }
    /**
     * Get Roads value
     * @return \StructType\AffectedRoadsStructure|null
     */
    public function getRoads()
    {
        return $this->Roads;
    }
    /**
     * Set Roads value
     * @param \StructType\AffectedRoadsStructure $roads
     * @return \StructType\AffectsScopeStructure
     */
    public function setRoads(\StructType\AffectedRoadsStructure $roads = null)
    {
        $this->Roads = $roads;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectsScopeStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectsScopeStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
