<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedRouteStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for information about the routes affected by a SITUATION.
 * @subpackage Structs
 */
class AffectedRouteStructure extends AbstractStructBase
{
    /**
     * The RouteRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a ROUTE affected by SITUATION.
     * - minOccurs: 0
     * @var \StructType\RouteRefStructure
     */
    public $RouteRef;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - documentation: DIRECTIONS affected by SITUATION.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DirectionStructure[]
     */
    public $Direction;
    /**
     * The Sections
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Sections
     */
    public $Sections;
    /**
     * The StopPoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StopPoints
     */
    public $StopPoints;
    /**
     * The RouteLinks
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RouteLinks
     */
    public $RouteLinks;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedRouteStructure
     * @uses AffectedRouteStructure::setRouteRef()
     * @uses AffectedRouteStructure::setDirection()
     * @uses AffectedRouteStructure::setSections()
     * @uses AffectedRouteStructure::setStopPoints()
     * @uses AffectedRouteStructure::setRouteLinks()
     * @uses AffectedRouteStructure::setExtensions()
     * @param \StructType\RouteRefStructure $routeRef
     * @param \StructType\DirectionStructure[] $direction
     * @param \StructType\Sections $sections
     * @param \StructType\StopPoints $stopPoints
     * @param \StructType\RouteLinks $routeLinks
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\RouteRefStructure $routeRef = null, array $direction = array(), \StructType\Sections $sections = null, \StructType\StopPoints $stopPoints = null, \StructType\RouteLinks $routeLinks = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setRouteRef($routeRef)
            ->setDirection($direction)
            ->setSections($sections)
            ->setStopPoints($stopPoints)
            ->setRouteLinks($routeLinks)
            ->setExtensions($extensions);
    }
    /**
     * Get RouteRef value
     * @return \StructType\RouteRefStructure|null
     */
    public function getRouteRef()
    {
        return $this->RouteRef;
    }
    /**
     * Set RouteRef value
     * @param \StructType\RouteRefStructure $routeRef
     * @return \StructType\AffectedRouteStructure
     */
    public function setRouteRef(\StructType\RouteRefStructure $routeRef = null)
    {
        $this->RouteRef = $routeRef;
        return $this;
    }
    /**
     * Get Direction value
     * @return \StructType\DirectionStructure[]|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @throws \InvalidArgumentException
     * @param \StructType\DirectionStructure[] $direction
     * @return \StructType\AffectedRouteStructure
     */
    public function setDirection(array $direction = array())
    {
        foreach ($direction as $affectedRouteStructureDirectionItem) {
            // validation for constraint: itemType
            if (!$affectedRouteStructureDirectionItem instanceof \StructType\DirectionStructure) {
                throw new \InvalidArgumentException(sprintf('The Direction property can only contain items of \StructType\DirectionStructure, "%s" given', is_object($affectedRouteStructureDirectionItem) ? get_class($affectedRouteStructureDirectionItem) : gettype($affectedRouteStructureDirectionItem)), __LINE__);
            }
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Add item to Direction value
     * @throws \InvalidArgumentException
     * @param \StructType\DirectionStructure $item
     * @return \StructType\AffectedRouteStructure
     */
    public function addToDirection(\StructType\DirectionStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DirectionStructure) {
            throw new \InvalidArgumentException(sprintf('The Direction property can only contain items of \StructType\DirectionStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Direction[] = $item;
        return $this;
    }
    /**
     * Get Sections value
     * @return \StructType\Sections|null
     */
    public function getSections()
    {
        return $this->Sections;
    }
    /**
     * Set Sections value
     * @param \StructType\Sections $sections
     * @return \StructType\AffectedRouteStructure
     */
    public function setSections(\StructType\Sections $sections = null)
    {
        $this->Sections = $sections;
        return $this;
    }
    /**
     * Get StopPoints value
     * @return \StructType\StopPoints|null
     */
    public function getStopPoints()
    {
        return $this->StopPoints;
    }
    /**
     * Set StopPoints value
     * @param \StructType\StopPoints $stopPoints
     * @return \StructType\AffectedRouteStructure
     */
    public function setStopPoints(\StructType\StopPoints $stopPoints = null)
    {
        $this->StopPoints = $stopPoints;
        return $this;
    }
    /**
     * Get RouteLinks value
     * @return \StructType\RouteLinks|null
     */
    public function getRouteLinks()
    {
        return $this->RouteLinks;
    }
    /**
     * Set RouteLinks value
     * @param \StructType\RouteLinks $routeLinks
     * @return \StructType\AffectedRouteStructure
     */
    public function setRouteLinks(\StructType\RouteLinks $routeLinks = null)
    {
        $this->RouteLinks = $routeLinks;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedRouteStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedRouteStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
