<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedRoadsStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Location model for scope of SITUATION or effect.
 * @subpackage Structs
 */
class AffectedRoadsStructure extends AbstractStructBase
{
    /**
     * The Datex2Locations
     * Meta informations extracted from the WSDL
     * - documentation: Refereences to road network locations affected by the SITUATION.
     * - minOccurs: 0
     * @var \StructType\GroupOfLocations
     */
    public $Datex2Locations;
    /**
     * The AffectedRoad
     * Meta informations extracted from the WSDL
     * - documentation: Description of affected road.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AffectedRoadStructure[]
     */
    public $AffectedRoad;
    /**
     * Constructor method for AffectedRoadsStructure
     * @uses AffectedRoadsStructure::setDatex2Locations()
     * @uses AffectedRoadsStructure::setAffectedRoad()
     * @param \StructType\GroupOfLocations $datex2Locations
     * @param \StructType\AffectedRoadStructure[] $affectedRoad
     */
    public function __construct(\StructType\GroupOfLocations $datex2Locations = null, array $affectedRoad = array())
    {
        $this
            ->setDatex2Locations($datex2Locations)
            ->setAffectedRoad($affectedRoad);
    }
    /**
     * Get Datex2Locations value
     * @return \StructType\GroupOfLocations|null
     */
    public function getDatex2Locations()
    {
        return $this->Datex2Locations;
    }
    /**
     * Set Datex2Locations value
     * @param \StructType\GroupOfLocations $datex2Locations
     * @return \StructType\AffectedRoadsStructure
     */
    public function setDatex2Locations(\StructType\GroupOfLocations $datex2Locations = null)
    {
        $this->Datex2Locations = $datex2Locations;
        return $this;
    }
    /**
     * Get AffectedRoad value
     * @return \StructType\AffectedRoadStructure[]|null
     */
    public function getAffectedRoad()
    {
        return $this->AffectedRoad;
    }
    /**
     * Set AffectedRoad value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedRoadStructure[] $affectedRoad
     * @return \StructType\AffectedRoadsStructure
     */
    public function setAffectedRoad(array $affectedRoad = array())
    {
        foreach ($affectedRoad as $affectedRoadsStructureAffectedRoadItem) {
            // validation for constraint: itemType
            if (!$affectedRoadsStructureAffectedRoadItem instanceof \StructType\AffectedRoadStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedRoad property can only contain items of \StructType\AffectedRoadStructure, "%s" given', is_object($affectedRoadsStructureAffectedRoadItem) ? get_class($affectedRoadsStructureAffectedRoadItem) : gettype($affectedRoadsStructureAffectedRoadItem)), __LINE__);
            }
        }
        $this->AffectedRoad = $affectedRoad;
        return $this;
    }
    /**
     * Add item to AffectedRoad value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedRoadStructure $item
     * @return \StructType\AffectedRoadsStructure
     */
    public function addToAffectedRoad(\StructType\AffectedRoadStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedRoadStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedRoad property can only contain items of \StructType\AffectedRoadStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedRoad[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedRoadsStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
