<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedRoadStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Raod scope for scope of SITUATION or effect. | Optional spatial projection of road. Can be used to distriute the path of the road to systems that do not already hold it. To pass just a Reference, use Datex2 location.
 * @subpackage Structs
 */
class AffectedRoadStructure extends AbstractStructBase
{
    /**
     * The Road
     * Meta informations extracted from the WSDL
     * - documentation: AFfected Road as described by a Date2x location.
     * - minOccurs: 0
     * @var \StructType\RoadsideReferencePointLinear
     */
    public $Road;
    /**
     * The LinkProjection
     * @var \StructType\LinkProjectionStructure
     */
    public $LinkProjection;
    /**
     * The Offset
     * @var \StructType\OffsetStructure
     */
    public $Offset;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedRoadStructure
     * @uses AffectedRoadStructure::setRoad()
     * @uses AffectedRoadStructure::setLinkProjection()
     * @uses AffectedRoadStructure::setOffset()
     * @uses AffectedRoadStructure::setExtensions()
     * @param \StructType\RoadsideReferencePointLinear $road
     * @param \StructType\LinkProjectionStructure $linkProjection
     * @param \StructType\OffsetStructure $offset
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\RoadsideReferencePointLinear $road = null, \StructType\LinkProjectionStructure $linkProjection = null, \StructType\OffsetStructure $offset = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setRoad($road)
            ->setLinkProjection($linkProjection)
            ->setOffset($offset)
            ->setExtensions($extensions);
    }
    /**
     * Get Road value
     * @return \StructType\RoadsideReferencePointLinear|null
     */
    public function getRoad()
    {
        return $this->Road;
    }
    /**
     * Set Road value
     * @param \StructType\RoadsideReferencePointLinear $road
     * @return \StructType\AffectedRoadStructure
     */
    public function setRoad(\StructType\RoadsideReferencePointLinear $road = null)
    {
        $this->Road = $road;
        return $this;
    }
    /**
     * Get LinkProjection value
     * @return \StructType\LinkProjectionStructure|null
     */
    public function getLinkProjection()
    {
        return $this->LinkProjection;
    }
    /**
     * Set LinkProjection value
     * @param \StructType\LinkProjectionStructure $linkProjection
     * @return \StructType\AffectedRoadStructure
     */
    public function setLinkProjection(\StructType\LinkProjectionStructure $linkProjection = null)
    {
        $this->LinkProjection = $linkProjection;
        return $this;
    }
    /**
     * Get Offset value
     * @return \StructType\OffsetStructure|null
     */
    public function getOffset()
    {
        return $this->Offset;
    }
    /**
     * Set Offset value
     * @param \StructType\OffsetStructure $offset
     * @return \StructType\AffectedRoadStructure
     */
    public function setOffset(\StructType\OffsetStructure $offset = null)
    {
        $this->Offset = $offset;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedRoadStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedRoadStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
