<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedPlaceStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for annotated references to a TOPOGRAPHIC PLACE.
 * @subpackage Structs
 */
class AffectedPlaceStructure extends AbstractStructBase
{
    /**
     * The PlaceRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a SITE or TOPOGRAPHIC PLACE (Locality).
     * - minOccurs: 0
     * @var string
     */
    public $PlaceRef;
    /**
     * The PrivateCode
     * Meta informations extracted from the WSDL
     * - documentation: Alternative identifier of SITE or TOPOGRAPHIC PLACE
     * - minOccurs: 0
     * @var string
     */
    public $PrivateCode;
    /**
     * The PlaceName
     * Meta informations extracted from the WSDL
     * - documentation: Name of SITE or TOPOGRAPHIC PLACE (locality) in which stop is found. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $PlaceName;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - documentation: Spatial coordinates of STOP POINT. Derivable from StopRef.
     * - minOccurs: 0
     * @var \StructType\LocationStructure
     */
    public $Location;
    /**
     * The PlaceCategory
     * Meta informations extracted from the WSDL
     * - documentation: Category of TOPGRAPHIC PLACE or SITE.
     * - minOccurs: 0
     * @var string
     */
    public $PlaceCategory;
    /**
     * The EquipmentRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to an EQUIPMENT found at location.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $EquipmentRef;
    /**
     * The AccessibilityAssessment
     * Meta informations extracted from the WSDL
     * - documentation: Changes to accessibility for SITE.
     * - minOccurs: 0
     * @var \StructType\AccessibilityAssessmentStructure
     */
    public $AccessibilityAssessment;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedPlaceStructure
     * @uses AffectedPlaceStructure::setPlaceRef()
     * @uses AffectedPlaceStructure::setPrivateCode()
     * @uses AffectedPlaceStructure::setPlaceName()
     * @uses AffectedPlaceStructure::setLocation()
     * @uses AffectedPlaceStructure::setPlaceCategory()
     * @uses AffectedPlaceStructure::setEquipmentRef()
     * @uses AffectedPlaceStructure::setAccessibilityAssessment()
     * @uses AffectedPlaceStructure::setExtensions()
     * @param string $placeRef
     * @param string $privateCode
     * @param \StructType\NaturalLanguageStringStructure[] $placeName
     * @param \StructType\LocationStructure $location
     * @param string $placeCategory
     * @param string[] $equipmentRef
     * @param \StructType\AccessibilityAssessmentStructure $accessibilityAssessment
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($placeRef = null, $privateCode = null, array $placeName = array(), \StructType\LocationStructure $location = null, $placeCategory = null, array $equipmentRef = array(), \StructType\AccessibilityAssessmentStructure $accessibilityAssessment = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setPlaceRef($placeRef)
            ->setPrivateCode($privateCode)
            ->setPlaceName($placeName)
            ->setLocation($location)
            ->setPlaceCategory($placeCategory)
            ->setEquipmentRef($equipmentRef)
            ->setAccessibilityAssessment($accessibilityAssessment)
            ->setExtensions($extensions);
    }
    /**
     * Get PlaceRef value
     * @return string|null
     */
    public function getPlaceRef()
    {
        return $this->PlaceRef;
    }
    /**
     * Set PlaceRef value
     * @param string $placeRef
     * @return \StructType\AffectedPlaceStructure
     */
    public function setPlaceRef($placeRef = null)
    {
        // validation for constraint: string
        if (!is_null($placeRef) && !is_string($placeRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeRef)), __LINE__);
        }
        $this->PlaceRef = $placeRef;
        return $this;
    }
    /**
     * Get PrivateCode value
     * @return string|null
     */
    public function getPrivateCode()
    {
        return $this->PrivateCode;
    }
    /**
     * Set PrivateCode value
     * @param string $privateCode
     * @return \StructType\AffectedPlaceStructure
     */
    public function setPrivateCode($privateCode = null)
    {
        // validation for constraint: string
        if (!is_null($privateCode) && !is_string($privateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($privateCode)), __LINE__);
        }
        $this->PrivateCode = $privateCode;
        return $this;
    }
    /**
     * Get PlaceName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getPlaceName()
    {
        return $this->PlaceName;
    }
    /**
     * Set PlaceName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $placeName
     * @return \StructType\AffectedPlaceStructure
     */
    public function setPlaceName(array $placeName = array())
    {
        foreach ($placeName as $affectedPlaceStructurePlaceNameItem) {
            // validation for constraint: itemType
            if (!$affectedPlaceStructurePlaceNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The PlaceName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedPlaceStructurePlaceNameItem) ? get_class($affectedPlaceStructurePlaceNameItem) : gettype($affectedPlaceStructurePlaceNameItem)), __LINE__);
            }
        }
        $this->PlaceName = $placeName;
        return $this;
    }
    /**
     * Add item to PlaceName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedPlaceStructure
     */
    public function addToPlaceName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The PlaceName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlaceName[] = $item;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\LocationStructure|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\LocationStructure $location
     * @return \StructType\AffectedPlaceStructure
     */
    public function setLocation(\StructType\LocationStructure $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get PlaceCategory value
     * @return string|null
     */
    public function getPlaceCategory()
    {
        return $this->PlaceCategory;
    }
    /**
     * Set PlaceCategory value
     * @param string $placeCategory
     * @return \StructType\AffectedPlaceStructure
     */
    public function setPlaceCategory($placeCategory = null)
    {
        // validation for constraint: string
        if (!is_null($placeCategory) && !is_string($placeCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeCategory)), __LINE__);
        }
        $this->PlaceCategory = $placeCategory;
        return $this;
    }
    /**
     * Get EquipmentRef value
     * @return string[]|null
     */
    public function getEquipmentRef()
    {
        return $this->EquipmentRef;
    }
    /**
     * Set EquipmentRef value
     * @throws \InvalidArgumentException
     * @param string[] $equipmentRef
     * @return \StructType\AffectedPlaceStructure
     */
    public function setEquipmentRef(array $equipmentRef = array())
    {
        foreach ($equipmentRef as $affectedPlaceStructureEquipmentRefItem) {
            // validation for constraint: itemType
            if (!is_string($affectedPlaceStructureEquipmentRefItem)) {
                throw new \InvalidArgumentException(sprintf('The EquipmentRef property can only contain items of NMTOKEN, "%s" given', is_object($affectedPlaceStructureEquipmentRefItem) ? get_class($affectedPlaceStructureEquipmentRefItem) : gettype($affectedPlaceStructureEquipmentRefItem)), __LINE__);
            }
        }
        $this->EquipmentRef = $equipmentRef;
        return $this;
    }
    /**
     * Add item to EquipmentRef value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AffectedPlaceStructure
     */
    public function addToEquipmentRef($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The EquipmentRef property can only contain items of NMTOKEN, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EquipmentRef[] = $item;
        return $this;
    }
    /**
     * Get AccessibilityAssessment value
     * @return \StructType\AccessibilityAssessmentStructure|null
     */
    public function getAccessibilityAssessment()
    {
        return $this->AccessibilityAssessment;
    }
    /**
     * Set AccessibilityAssessment value
     * @param \StructType\AccessibilityAssessmentStructure $accessibilityAssessment
     * @return \StructType\AffectedPlaceStructure
     */
    public function setAccessibilityAssessment(\StructType\AccessibilityAssessmentStructure $accessibilityAssessment = null)
    {
        $this->AccessibilityAssessment = $accessibilityAssessment;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedPlaceStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedPlaceStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
