<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedNavigationPaths StructType
 * Meta informations extracted from the WSDL
 * - documentation: PathLinks affected by SITUATION.
 * @subpackage Structs
 */
class AffectedNavigationPaths extends AbstractStructBase
{
    /**
     * The NavigationPathRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\NavigationPathRefStructure[]
     */
    public $NavigationPathRef;
    /**
     * Constructor method for AffectedNavigationPaths
     * @uses AffectedNavigationPaths::setNavigationPathRef()
     * @param \StructType\NavigationPathRefStructure[] $navigationPathRef
     */
    public function __construct(array $navigationPathRef = array())
    {
        $this
            ->setNavigationPathRef($navigationPathRef);
    }
    /**
     * Get NavigationPathRef value
     * @return \StructType\NavigationPathRefStructure[]|null
     */
    public function getNavigationPathRef()
    {
        return $this->NavigationPathRef;
    }
    /**
     * Set NavigationPathRef value
     * @throws \InvalidArgumentException
     * @param \StructType\NavigationPathRefStructure[] $navigationPathRef
     * @return \StructType\AffectedNavigationPaths
     */
    public function setNavigationPathRef(array $navigationPathRef = array())
    {
        foreach ($navigationPathRef as $affectedNavigationPathsNavigationPathRefItem) {
            // validation for constraint: itemType
            if (!$affectedNavigationPathsNavigationPathRefItem instanceof \StructType\NavigationPathRefStructure) {
                throw new \InvalidArgumentException(sprintf('The NavigationPathRef property can only contain items of \StructType\NavigationPathRefStructure, "%s" given', is_object($affectedNavigationPathsNavigationPathRefItem) ? get_class($affectedNavigationPathsNavigationPathRefItem) : gettype($affectedNavigationPathsNavigationPathRefItem)), __LINE__);
            }
        }
        $this->NavigationPathRef = $navigationPathRef;
        return $this;
    }
    /**
     * Add item to NavigationPathRef value
     * @throws \InvalidArgumentException
     * @param \StructType\NavigationPathRefStructure $item
     * @return \StructType\AffectedNavigationPaths
     */
    public function addToNavigationPathRef(\StructType\NavigationPathRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NavigationPathRefStructure) {
            throw new \InvalidArgumentException(sprintf('The NavigationPathRef property can only contain items of \StructType\NavigationPathRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NavigationPathRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedNavigationPaths
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
