<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedConnectionLinkStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a reference Information about a CONNECTION link from a given stop that is affected by a SITUATION.
 * @subpackage Structs
 */
class AffectedConnectionLinkStructure extends AbstractStructBase
{
    /**
     * The ConnectionLinkRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a CONNECTION link affected by a SITUATION.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ConnectionLinkRefStructure[]
     */
    public $ConnectionLinkRef;
    /**
     * The ConnectionName
     * Meta informations extracted from the WSDL
     * - documentation: Name of CONNECTION link affected by a SITUATION.
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $ConnectionName;
    /**
     * The AllLines
     * @var string
     */
    public $AllLines;
    /**
     * The LineRef
     * @var \StructType\LineRefStructure
     */
    public $LineRef;
    /**
     * The PublishedLineName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $PublishedLineName;
    /**
     * The ConnectingStopPointRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to other connecting STOP POINT of a CONNECTION link. If blank, both feeder and distributor vehicles go to same stop. | Reference to a STOP POINT.
     * - minOccurs: 0
     * @var \StructType\StopPointRefStructure
     */
    public $ConnectingStopPointRef;
    /**
     * The ConnectingStopPointName
     * Meta informations extracted from the WSDL
     * - documentation: Name of other connecting STOP POINT of a CONNECTION link. Derivable from StopRef. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $ConnectingStopPointName;
    /**
     * The ConnectingZoneRef
     * Meta informations extracted from the WSDL
     * - documentation: Zone in which connecting stop lies.
     * - minOccurs: 0
     * @var \StructType\ZoneRefStructure
     */
    public $ConnectingZoneRef;
    /**
     * The ConnectionDirection
     * Meta informations extracted from the WSDL
     * - default: both
     * - documentation: Direction of SERVICE JOURNEY INTERCHANGE. Default is 'both'.
     * - minOccurs: 0
     * @var string
     */
    public $ConnectionDirection;
    /**
     * The AffectedPathLink
     * Meta informations extracted from the WSDL
     * - documentation: PATH LINKs affected by a SITUATION.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AffectedPathLinkStructure[]
     */
    public $AffectedPathLink;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for AffectedConnectionLinkStructure
     * @uses AffectedConnectionLinkStructure::setConnectionLinkRef()
     * @uses AffectedConnectionLinkStructure::setConnectionName()
     * @uses AffectedConnectionLinkStructure::setAllLines()
     * @uses AffectedConnectionLinkStructure::setLineRef()
     * @uses AffectedConnectionLinkStructure::setPublishedLineName()
     * @uses AffectedConnectionLinkStructure::setConnectingStopPointRef()
     * @uses AffectedConnectionLinkStructure::setConnectingStopPointName()
     * @uses AffectedConnectionLinkStructure::setConnectingZoneRef()
     * @uses AffectedConnectionLinkStructure::setConnectionDirection()
     * @uses AffectedConnectionLinkStructure::setAffectedPathLink()
     * @uses AffectedConnectionLinkStructure::setExtensions()
     * @param \StructType\ConnectionLinkRefStructure[] $connectionLinkRef
     * @param \StructType\NaturalLanguageStringStructure $connectionName
     * @param string $allLines
     * @param \StructType\LineRefStructure $lineRef
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @param \StructType\StopPointRefStructure $connectingStopPointRef
     * @param \StructType\NaturalLanguageStringStructure[] $connectingStopPointName
     * @param \StructType\ZoneRefStructure $connectingZoneRef
     * @param string $connectionDirection
     * @param \StructType\AffectedPathLinkStructure[] $affectedPathLink
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(array $connectionLinkRef = array(), \StructType\NaturalLanguageStringStructure $connectionName = null, $allLines = null, \StructType\LineRefStructure $lineRef = null, \StructType\NaturalLanguageStringStructure $publishedLineName = null, \StructType\StopPointRefStructure $connectingStopPointRef = null, array $connectingStopPointName = array(), \StructType\ZoneRefStructure $connectingZoneRef = null, $connectionDirection = 'both', array $affectedPathLink = array(), \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setConnectionLinkRef($connectionLinkRef)
            ->setConnectionName($connectionName)
            ->setAllLines($allLines)
            ->setLineRef($lineRef)
            ->setPublishedLineName($publishedLineName)
            ->setConnectingStopPointRef($connectingStopPointRef)
            ->setConnectingStopPointName($connectingStopPointName)
            ->setConnectingZoneRef($connectingZoneRef)
            ->setConnectionDirection($connectionDirection)
            ->setAffectedPathLink($affectedPathLink)
            ->setExtensions($extensions);
    }
    /**
     * Get ConnectionLinkRef value
     * @return \StructType\ConnectionLinkRefStructure[]|null
     */
    public function getConnectionLinkRef()
    {
        return $this->ConnectionLinkRef;
    }
    /**
     * Set ConnectionLinkRef value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionLinkRefStructure[] $connectionLinkRef
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function setConnectionLinkRef(array $connectionLinkRef = array())
    {
        foreach ($connectionLinkRef as $affectedConnectionLinkStructureConnectionLinkRefItem) {
            // validation for constraint: itemType
            if (!$affectedConnectionLinkStructureConnectionLinkRefItem instanceof \StructType\ConnectionLinkRefStructure) {
                throw new \InvalidArgumentException(sprintf('The ConnectionLinkRef property can only contain items of \StructType\ConnectionLinkRefStructure, "%s" given', is_object($affectedConnectionLinkStructureConnectionLinkRefItem) ? get_class($affectedConnectionLinkStructureConnectionLinkRefItem) : gettype($affectedConnectionLinkStructureConnectionLinkRefItem)), __LINE__);
            }
        }
        $this->ConnectionLinkRef = $connectionLinkRef;
        return $this;
    }
    /**
     * Add item to ConnectionLinkRef value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionLinkRefStructure $item
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function addToConnectionLinkRef(\StructType\ConnectionLinkRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConnectionLinkRefStructure) {
            throw new \InvalidArgumentException(sprintf('The ConnectionLinkRef property can only contain items of \StructType\ConnectionLinkRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ConnectionLinkRef[] = $item;
        return $this;
    }
    /**
     * Get ConnectionName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getConnectionName()
    {
        return $this->ConnectionName;
    }
    /**
     * Set ConnectionName value
     * @param \StructType\NaturalLanguageStringStructure $connectionName
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function setConnectionName(\StructType\NaturalLanguageStringStructure $connectionName = null)
    {
        $this->ConnectionName = $connectionName;
        return $this;
    }
    /**
     * Get AllLines value
     * @return string|null
     */
    public function getAllLines()
    {
        return $this->AllLines;
    }
    /**
     * Set AllLines value
     * @uses \EnumType\EmptyType::valueIsValid()
     * @uses \EnumType\EmptyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allLines
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function setAllLines($allLines = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmptyType::valueIsValid($allLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $allLines, implode(', ', \EnumType\EmptyType::getValidValues())), __LINE__);
        }
        $this->AllLines = $allLines;
        return $this;
    }
    /**
     * Get LineRef value
     * @return \StructType\LineRefStructure|null
     */
    public function getLineRef()
    {
        return $this->LineRef;
    }
    /**
     * Set LineRef value
     * @param \StructType\LineRefStructure $lineRef
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function setLineRef(\StructType\LineRefStructure $lineRef = null)
    {
        $this->LineRef = $lineRef;
        return $this;
    }
    /**
     * Get PublishedLineName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getPublishedLineName()
    {
        return $this->PublishedLineName;
    }
    /**
     * Set PublishedLineName value
     * @param \StructType\NaturalLanguageStringStructure $publishedLineName
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function setPublishedLineName(\StructType\NaturalLanguageStringStructure $publishedLineName = null)
    {
        $this->PublishedLineName = $publishedLineName;
        return $this;
    }
    /**
     * Get ConnectingStopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getConnectingStopPointRef()
    {
        return $this->ConnectingStopPointRef;
    }
    /**
     * Set ConnectingStopPointRef value
     * @param \StructType\StopPointRefStructure $connectingStopPointRef
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function setConnectingStopPointRef(\StructType\StopPointRefStructure $connectingStopPointRef = null)
    {
        $this->ConnectingStopPointRef = $connectingStopPointRef;
        return $this;
    }
    /**
     * Get ConnectingStopPointName value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getConnectingStopPointName()
    {
        return $this->ConnectingStopPointName;
    }
    /**
     * Set ConnectingStopPointName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $connectingStopPointName
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function setConnectingStopPointName(array $connectingStopPointName = array())
    {
        foreach ($connectingStopPointName as $affectedConnectionLinkStructureConnectingStopPointNameItem) {
            // validation for constraint: itemType
            if (!$affectedConnectionLinkStructureConnectingStopPointNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The ConnectingStopPointName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($affectedConnectionLinkStructureConnectingStopPointNameItem) ? get_class($affectedConnectionLinkStructureConnectingStopPointNameItem) : gettype($affectedConnectionLinkStructureConnectingStopPointNameItem)), __LINE__);
            }
        }
        $this->ConnectingStopPointName = $connectingStopPointName;
        return $this;
    }
    /**
     * Add item to ConnectingStopPointName value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function addToConnectingStopPointName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The ConnectingStopPointName property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ConnectingStopPointName[] = $item;
        return $this;
    }
    /**
     * Get ConnectingZoneRef value
     * @return \StructType\ZoneRefStructure|null
     */
    public function getConnectingZoneRef()
    {
        return $this->ConnectingZoneRef;
    }
    /**
     * Set ConnectingZoneRef value
     * @param \StructType\ZoneRefStructure $connectingZoneRef
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function setConnectingZoneRef(\StructType\ZoneRefStructure $connectingZoneRef = null)
    {
        $this->ConnectingZoneRef = $connectingZoneRef;
        return $this;
    }
    /**
     * Get ConnectionDirection value
     * @return string|null
     */
    public function getConnectionDirection()
    {
        return $this->ConnectionDirection;
    }
    /**
     * Set ConnectionDirection value
     * @uses \EnumType\ConnectionDirectionEnumeration::valueIsValid()
     * @uses \EnumType\ConnectionDirectionEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectionDirection
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function setConnectionDirection($connectionDirection = 'both')
    {
        // validation for constraint: enumeration
        if (!\EnumType\ConnectionDirectionEnumeration::valueIsValid($connectionDirection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectionDirection, implode(', ', \EnumType\ConnectionDirectionEnumeration::getValidValues())), __LINE__);
        }
        $this->ConnectionDirection = $connectionDirection;
        return $this;
    }
    /**
     * Get AffectedPathLink value
     * @return \StructType\AffectedPathLinkStructure[]|null
     */
    public function getAffectedPathLink()
    {
        return $this->AffectedPathLink;
    }
    /**
     * Set AffectedPathLink value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedPathLinkStructure[] $affectedPathLink
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function setAffectedPathLink(array $affectedPathLink = array())
    {
        foreach ($affectedPathLink as $affectedConnectionLinkStructureAffectedPathLinkItem) {
            // validation for constraint: itemType
            if (!$affectedConnectionLinkStructureAffectedPathLinkItem instanceof \StructType\AffectedPathLinkStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedPathLink property can only contain items of \StructType\AffectedPathLinkStructure, "%s" given', is_object($affectedConnectionLinkStructureAffectedPathLinkItem) ? get_class($affectedConnectionLinkStructureAffectedPathLinkItem) : gettype($affectedConnectionLinkStructureAffectedPathLinkItem)), __LINE__);
            }
        }
        $this->AffectedPathLink = $affectedPathLink;
        return $this;
    }
    /**
     * Add item to AffectedPathLink value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedPathLinkStructure $item
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function addToAffectedPathLink(\StructType\AffectedPathLinkStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedPathLinkStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedPathLink property can only contain items of \StructType\AffectedPathLinkStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedPathLink[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedConnectionLinkStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
