<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffectedCallStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for information about a CALL affected by an SITUATION.
 * @subpackage Structs
 */
class AffectedCallStructure extends AffectedStopPointStructure
{
    /**
     * The Order
     * Meta informations extracted from the WSDL
     * - documentation: Order of visit to stop within JORUNYE PATTERN of journey.
     * - minOccurs: 0
     * @var int
     */
    public $Order;
    /**
     * The CallCondition
     * Meta informations extracted from the WSDL
     * - documentation: Status of CALL TPEG 13_6
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CallCondition;
    /**
     * The VehicleAtStop
     * @var bool
     */
    public $VehicleAtStop;
    /**
     * The VehicleLocationAtStop
     * @var \StructType\LocationStructure
     */
    public $VehicleLocationAtStop;
    /**
     * The TimingPoint
     * @var bool
     */
    public $TimingPoint;
    /**
     * The BoardingStretch
     * @var bool
     */
    public $BoardingStretch;
    /**
     * The RequestStop
     * @var bool
     */
    public $RequestStop;
    /**
     * The OriginDisplay
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $OriginDisplay;
    /**
     * The DestinationDisplay
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DestinationDisplay;
    /**
     * The AimedArrivalTime
     * @var string
     */
    public $AimedArrivalTime;
    /**
     * The ActualArrivalTime
     * @var string
     */
    public $ActualArrivalTime;
    /**
     * The ExpectedArrivalTime
     * @var string
     */
    public $ExpectedArrivalTime;
    /**
     * The ArrivalStatus
     * @var string
     */
    public $ArrivalStatus;
    /**
     * The ArrivalPlatformName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $ArrivalPlatformName;
    /**
     * The ArrivalBoardingActivity
     * @var string
     */
    public $ArrivalBoardingActivity;
    /**
     * The AimedDepartureTime
     * @var string
     */
    public $AimedDepartureTime;
    /**
     * The ActualDepartureTime
     * @var string
     */
    public $ActualDepartureTime;
    /**
     * The ExpectedDepartureTime
     * @var string
     */
    public $ExpectedDepartureTime;
    /**
     * The DepartureStatus
     * @var string
     */
    public $DepartureStatus;
    /**
     * The DeparturePlatformName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $DeparturePlatformName;
    /**
     * The DepartureBoardingActivity
     * @var string
     */
    public $DepartureBoardingActivity;
    /**
     * The AimedHeadwayInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $AimedHeadwayInterval;
    /**
     * The ExpectedHeadwayInterval
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $ExpectedHeadwayInterval;
    /**
     * The AffectedInterchange
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AffectedInterchangeStructure[]
     */
    public $AffectedInterchange;
    /**
     * Constructor method for AffectedCallStructure
     * @uses AffectedCallStructure::setOrder()
     * @uses AffectedCallStructure::setCallCondition()
     * @uses AffectedCallStructure::setVehicleAtStop()
     * @uses AffectedCallStructure::setVehicleLocationAtStop()
     * @uses AffectedCallStructure::setTimingPoint()
     * @uses AffectedCallStructure::setBoardingStretch()
     * @uses AffectedCallStructure::setRequestStop()
     * @uses AffectedCallStructure::setOriginDisplay()
     * @uses AffectedCallStructure::setDestinationDisplay()
     * @uses AffectedCallStructure::setAimedArrivalTime()
     * @uses AffectedCallStructure::setActualArrivalTime()
     * @uses AffectedCallStructure::setExpectedArrivalTime()
     * @uses AffectedCallStructure::setArrivalStatus()
     * @uses AffectedCallStructure::setArrivalPlatformName()
     * @uses AffectedCallStructure::setArrivalBoardingActivity()
     * @uses AffectedCallStructure::setAimedDepartureTime()
     * @uses AffectedCallStructure::setActualDepartureTime()
     * @uses AffectedCallStructure::setExpectedDepartureTime()
     * @uses AffectedCallStructure::setDepartureStatus()
     * @uses AffectedCallStructure::setDeparturePlatformName()
     * @uses AffectedCallStructure::setDepartureBoardingActivity()
     * @uses AffectedCallStructure::setAimedHeadwayInterval()
     * @uses AffectedCallStructure::setExpectedHeadwayInterval()
     * @uses AffectedCallStructure::setAffectedInterchange()
     * @param int $order
     * @param string[] $callCondition
     * @param bool $vehicleAtStop
     * @param \StructType\LocationStructure $vehicleLocationAtStop
     * @param bool $timingPoint
     * @param bool $boardingStretch
     * @param bool $requestStop
     * @param \StructType\NaturalLanguageStringStructure $originDisplay
     * @param \StructType\NaturalLanguageStringStructure $destinationDisplay
     * @param string $aimedArrivalTime
     * @param string $actualArrivalTime
     * @param string $expectedArrivalTime
     * @param string $arrivalStatus
     * @param \StructType\NaturalLanguageStringStructure $arrivalPlatformName
     * @param string $arrivalBoardingActivity
     * @param string $aimedDepartureTime
     * @param string $actualDepartureTime
     * @param string $expectedDepartureTime
     * @param string $departureStatus
     * @param \StructType\NaturalLanguageStringStructure $departurePlatformName
     * @param string $departureBoardingActivity
     * @param string $aimedHeadwayInterval
     * @param string $expectedHeadwayInterval
     * @param \StructType\AffectedInterchangeStructure[] $affectedInterchange
     */
    public function __construct($order = null, array $callCondition = array(), $vehicleAtStop = null, \StructType\LocationStructure $vehicleLocationAtStop = null, $timingPoint = null, $boardingStretch = null, $requestStop = null, \StructType\NaturalLanguageStringStructure $originDisplay = null, \StructType\NaturalLanguageStringStructure $destinationDisplay = null, $aimedArrivalTime = null, $actualArrivalTime = null, $expectedArrivalTime = null, $arrivalStatus = null, \StructType\NaturalLanguageStringStructure $arrivalPlatformName = null, $arrivalBoardingActivity = null, $aimedDepartureTime = null, $actualDepartureTime = null, $expectedDepartureTime = null, $departureStatus = null, \StructType\NaturalLanguageStringStructure $departurePlatformName = null, $departureBoardingActivity = null, $aimedHeadwayInterval = null, $expectedHeadwayInterval = null, array $affectedInterchange = array())
    {
        $this
            ->setOrder($order)
            ->setCallCondition($callCondition)
            ->setVehicleAtStop($vehicleAtStop)
            ->setVehicleLocationAtStop($vehicleLocationAtStop)
            ->setTimingPoint($timingPoint)
            ->setBoardingStretch($boardingStretch)
            ->setRequestStop($requestStop)
            ->setOriginDisplay($originDisplay)
            ->setDestinationDisplay($destinationDisplay)
            ->setAimedArrivalTime($aimedArrivalTime)
            ->setActualArrivalTime($actualArrivalTime)
            ->setExpectedArrivalTime($expectedArrivalTime)
            ->setArrivalStatus($arrivalStatus)
            ->setArrivalPlatformName($arrivalPlatformName)
            ->setArrivalBoardingActivity($arrivalBoardingActivity)
            ->setAimedDepartureTime($aimedDepartureTime)
            ->setActualDepartureTime($actualDepartureTime)
            ->setExpectedDepartureTime($expectedDepartureTime)
            ->setDepartureStatus($departureStatus)
            ->setDeparturePlatformName($departurePlatformName)
            ->setDepartureBoardingActivity($departureBoardingActivity)
            ->setAimedHeadwayInterval($aimedHeadwayInterval)
            ->setExpectedHeadwayInterval($expectedHeadwayInterval)
            ->setAffectedInterchange($affectedInterchange);
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\AffectedCallStructure
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get CallCondition value
     * @return string[]|null
     */
    public function getCallCondition()
    {
        return $this->CallCondition;
    }
    /**
     * Set CallCondition value
     * @uses \EnumType\RoutePointTypeEnumeration::valueIsValid()
     * @uses \EnumType\RoutePointTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $callCondition
     * @return \StructType\AffectedCallStructure
     */
    public function setCallCondition(array $callCondition = array())
    {
        $invalidValues = array();
        foreach ($callCondition as $affectedCallStructureCallConditionItem) {
            if (!\EnumType\RoutePointTypeEnumeration::valueIsValid($affectedCallStructureCallConditionItem)) {
                $invalidValues[] = var_export($affectedCallStructureCallConditionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\RoutePointTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->CallCondition = $callCondition;
        return $this;
    }
    /**
     * Add item to CallCondition value
     * @uses \EnumType\RoutePointTypeEnumeration::valueIsValid()
     * @uses \EnumType\RoutePointTypeEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AffectedCallStructure
     */
    public function addToCallCondition($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoutePointTypeEnumeration::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\RoutePointTypeEnumeration::getValidValues())), __LINE__);
        }
        $this->CallCondition[] = $item;
        return $this;
    }
    /**
     * Get VehicleAtStop value
     * @return bool|null
     */
    public function getVehicleAtStop()
    {
        return $this->VehicleAtStop;
    }
    /**
     * Set VehicleAtStop value
     * @param bool $vehicleAtStop
     * @return \StructType\AffectedCallStructure
     */
    public function setVehicleAtStop($vehicleAtStop = null)
    {
        // validation for constraint: boolean
        if (!is_null($vehicleAtStop) && !is_bool($vehicleAtStop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($vehicleAtStop)), __LINE__);
        }
        $this->VehicleAtStop = $vehicleAtStop;
        return $this;
    }
    /**
     * Get VehicleLocationAtStop value
     * @return \StructType\LocationStructure|null
     */
    public function getVehicleLocationAtStop()
    {
        return $this->VehicleLocationAtStop;
    }
    /**
     * Set VehicleLocationAtStop value
     * @param \StructType\LocationStructure $vehicleLocationAtStop
     * @return \StructType\AffectedCallStructure
     */
    public function setVehicleLocationAtStop(\StructType\LocationStructure $vehicleLocationAtStop = null)
    {
        $this->VehicleLocationAtStop = $vehicleLocationAtStop;
        return $this;
    }
    /**
     * Get TimingPoint value
     * @return bool|null
     */
    public function getTimingPoint()
    {
        return $this->TimingPoint;
    }
    /**
     * Set TimingPoint value
     * @param bool $timingPoint
     * @return \StructType\AffectedCallStructure
     */
    public function setTimingPoint($timingPoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($timingPoint) && !is_bool($timingPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($timingPoint)), __LINE__);
        }
        $this->TimingPoint = $timingPoint;
        return $this;
    }
    /**
     * Get BoardingStretch value
     * @return bool|null
     */
    public function getBoardingStretch()
    {
        return $this->BoardingStretch;
    }
    /**
     * Set BoardingStretch value
     * @param bool $boardingStretch
     * @return \StructType\AffectedCallStructure
     */
    public function setBoardingStretch($boardingStretch = null)
    {
        // validation for constraint: boolean
        if (!is_null($boardingStretch) && !is_bool($boardingStretch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($boardingStretch)), __LINE__);
        }
        $this->BoardingStretch = $boardingStretch;
        return $this;
    }
    /**
     * Get RequestStop value
     * @return bool|null
     */
    public function getRequestStop()
    {
        return $this->RequestStop;
    }
    /**
     * Set RequestStop value
     * @param bool $requestStop
     * @return \StructType\AffectedCallStructure
     */
    public function setRequestStop($requestStop = null)
    {
        // validation for constraint: boolean
        if (!is_null($requestStop) && !is_bool($requestStop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requestStop)), __LINE__);
        }
        $this->RequestStop = $requestStop;
        return $this;
    }
    /**
     * Get OriginDisplay value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getOriginDisplay()
    {
        return $this->OriginDisplay;
    }
    /**
     * Set OriginDisplay value
     * @param \StructType\NaturalLanguageStringStructure $originDisplay
     * @return \StructType\AffectedCallStructure
     */
    public function setOriginDisplay(\StructType\NaturalLanguageStringStructure $originDisplay = null)
    {
        $this->OriginDisplay = $originDisplay;
        return $this;
    }
    /**
     * Get DestinationDisplay value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDestinationDisplay()
    {
        return $this->DestinationDisplay;
    }
    /**
     * Set DestinationDisplay value
     * @param \StructType\NaturalLanguageStringStructure $destinationDisplay
     * @return \StructType\AffectedCallStructure
     */
    public function setDestinationDisplay(\StructType\NaturalLanguageStringStructure $destinationDisplay = null)
    {
        $this->DestinationDisplay = $destinationDisplay;
        return $this;
    }
    /**
     * Get AimedArrivalTime value
     * @return string|null
     */
    public function getAimedArrivalTime()
    {
        return $this->AimedArrivalTime;
    }
    /**
     * Set AimedArrivalTime value
     * @param string $aimedArrivalTime
     * @return \StructType\AffectedCallStructure
     */
    public function setAimedArrivalTime($aimedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedArrivalTime) && !is_string($aimedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedArrivalTime)), __LINE__);
        }
        $this->AimedArrivalTime = $aimedArrivalTime;
        return $this;
    }
    /**
     * Get ActualArrivalTime value
     * @return string|null
     */
    public function getActualArrivalTime()
    {
        return $this->ActualArrivalTime;
    }
    /**
     * Set ActualArrivalTime value
     * @param string $actualArrivalTime
     * @return \StructType\AffectedCallStructure
     */
    public function setActualArrivalTime($actualArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($actualArrivalTime) && !is_string($actualArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualArrivalTime)), __LINE__);
        }
        $this->ActualArrivalTime = $actualArrivalTime;
        return $this;
    }
    /**
     * Get ExpectedArrivalTime value
     * @return string|null
     */
    public function getExpectedArrivalTime()
    {
        return $this->ExpectedArrivalTime;
    }
    /**
     * Set ExpectedArrivalTime value
     * @param string $expectedArrivalTime
     * @return \StructType\AffectedCallStructure
     */
    public function setExpectedArrivalTime($expectedArrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($expectedArrivalTime) && !is_string($expectedArrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedArrivalTime)), __LINE__);
        }
        $this->ExpectedArrivalTime = $expectedArrivalTime;
        return $this;
    }
    /**
     * Get ArrivalStatus value
     * @return string|null
     */
    public function getArrivalStatus()
    {
        return $this->ArrivalStatus;
    }
    /**
     * Set ArrivalStatus value
     * @uses \EnumType\CallStatusEnumeration::valueIsValid()
     * @uses \EnumType\CallStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrivalStatus
     * @return \StructType\AffectedCallStructure
     */
    public function setArrivalStatus($arrivalStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CallStatusEnumeration::valueIsValid($arrivalStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $arrivalStatus, implode(', ', \EnumType\CallStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->ArrivalStatus = $arrivalStatus;
        return $this;
    }
    /**
     * Get ArrivalPlatformName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getArrivalPlatformName()
    {
        return $this->ArrivalPlatformName;
    }
    /**
     * Set ArrivalPlatformName value
     * @param \StructType\NaturalLanguageStringStructure $arrivalPlatformName
     * @return \StructType\AffectedCallStructure
     */
    public function setArrivalPlatformName(\StructType\NaturalLanguageStringStructure $arrivalPlatformName = null)
    {
        $this->ArrivalPlatformName = $arrivalPlatformName;
        return $this;
    }
    /**
     * Get ArrivalBoardingActivity value
     * @return string|null
     */
    public function getArrivalBoardingActivity()
    {
        return $this->ArrivalBoardingActivity;
    }
    /**
     * Set ArrivalBoardingActivity value
     * @uses \EnumType\ArrivalBoardingActivityEnumeration::valueIsValid()
     * @uses \EnumType\ArrivalBoardingActivityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $arrivalBoardingActivity
     * @return \StructType\AffectedCallStructure
     */
    public function setArrivalBoardingActivity($arrivalBoardingActivity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ArrivalBoardingActivityEnumeration::valueIsValid($arrivalBoardingActivity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $arrivalBoardingActivity, implode(', ', \EnumType\ArrivalBoardingActivityEnumeration::getValidValues())), __LINE__);
        }
        $this->ArrivalBoardingActivity = $arrivalBoardingActivity;
        return $this;
    }
    /**
     * Get AimedDepartureTime value
     * @return string|null
     */
    public function getAimedDepartureTime()
    {
        return $this->AimedDepartureTime;
    }
    /**
     * Set AimedDepartureTime value
     * @param string $aimedDepartureTime
     * @return \StructType\AffectedCallStructure
     */
    public function setAimedDepartureTime($aimedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($aimedDepartureTime) && !is_string($aimedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedDepartureTime)), __LINE__);
        }
        $this->AimedDepartureTime = $aimedDepartureTime;
        return $this;
    }
    /**
     * Get ActualDepartureTime value
     * @return string|null
     */
    public function getActualDepartureTime()
    {
        return $this->ActualDepartureTime;
    }
    /**
     * Set ActualDepartureTime value
     * @param string $actualDepartureTime
     * @return \StructType\AffectedCallStructure
     */
    public function setActualDepartureTime($actualDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($actualDepartureTime) && !is_string($actualDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualDepartureTime)), __LINE__);
        }
        $this->ActualDepartureTime = $actualDepartureTime;
        return $this;
    }
    /**
     * Get ExpectedDepartureTime value
     * @return string|null
     */
    public function getExpectedDepartureTime()
    {
        return $this->ExpectedDepartureTime;
    }
    /**
     * Set ExpectedDepartureTime value
     * @param string $expectedDepartureTime
     * @return \StructType\AffectedCallStructure
     */
    public function setExpectedDepartureTime($expectedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($expectedDepartureTime) && !is_string($expectedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedDepartureTime)), __LINE__);
        }
        $this->ExpectedDepartureTime = $expectedDepartureTime;
        return $this;
    }
    /**
     * Get DepartureStatus value
     * @return string|null
     */
    public function getDepartureStatus()
    {
        return $this->DepartureStatus;
    }
    /**
     * Set DepartureStatus value
     * @uses \EnumType\CallStatusEnumeration::valueIsValid()
     * @uses \EnumType\CallStatusEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureStatus
     * @return \StructType\AffectedCallStructure
     */
    public function setDepartureStatus($departureStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CallStatusEnumeration::valueIsValid($departureStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $departureStatus, implode(', ', \EnumType\CallStatusEnumeration::getValidValues())), __LINE__);
        }
        $this->DepartureStatus = $departureStatus;
        return $this;
    }
    /**
     * Get DeparturePlatformName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getDeparturePlatformName()
    {
        return $this->DeparturePlatformName;
    }
    /**
     * Set DeparturePlatformName value
     * @param \StructType\NaturalLanguageStringStructure $departurePlatformName
     * @return \StructType\AffectedCallStructure
     */
    public function setDeparturePlatformName(\StructType\NaturalLanguageStringStructure $departurePlatformName = null)
    {
        $this->DeparturePlatformName = $departurePlatformName;
        return $this;
    }
    /**
     * Get DepartureBoardingActivity value
     * @return string|null
     */
    public function getDepartureBoardingActivity()
    {
        return $this->DepartureBoardingActivity;
    }
    /**
     * Set DepartureBoardingActivity value
     * @uses \EnumType\DepartureBoardingActivityEnumeration::valueIsValid()
     * @uses \EnumType\DepartureBoardingActivityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureBoardingActivity
     * @return \StructType\AffectedCallStructure
     */
    public function setDepartureBoardingActivity($departureBoardingActivity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DepartureBoardingActivityEnumeration::valueIsValid($departureBoardingActivity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $departureBoardingActivity, implode(', ', \EnumType\DepartureBoardingActivityEnumeration::getValidValues())), __LINE__);
        }
        $this->DepartureBoardingActivity = $departureBoardingActivity;
        return $this;
    }
    /**
     * Get AimedHeadwayInterval value
     * @return string|null
     */
    public function getAimedHeadwayInterval()
    {
        return $this->AimedHeadwayInterval;
    }
    /**
     * Set AimedHeadwayInterval value
     * @param string $aimedHeadwayInterval
     * @return \StructType\AffectedCallStructure
     */
    public function setAimedHeadwayInterval($aimedHeadwayInterval = null)
    {
        // validation for constraint: string
        if (!is_null($aimedHeadwayInterval) && !is_string($aimedHeadwayInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aimedHeadwayInterval)), __LINE__);
        }
        $this->AimedHeadwayInterval = $aimedHeadwayInterval;
        return $this;
    }
    /**
     * Get ExpectedHeadwayInterval value
     * @return string|null
     */
    public function getExpectedHeadwayInterval()
    {
        return $this->ExpectedHeadwayInterval;
    }
    /**
     * Set ExpectedHeadwayInterval value
     * @param string $expectedHeadwayInterval
     * @return \StructType\AffectedCallStructure
     */
    public function setExpectedHeadwayInterval($expectedHeadwayInterval = null)
    {
        // validation for constraint: string
        if (!is_null($expectedHeadwayInterval) && !is_string($expectedHeadwayInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedHeadwayInterval)), __LINE__);
        }
        $this->ExpectedHeadwayInterval = $expectedHeadwayInterval;
        return $this;
    }
    /**
     * Get AffectedInterchange value
     * @return \StructType\AffectedInterchangeStructure[]|null
     */
    public function getAffectedInterchange()
    {
        return $this->AffectedInterchange;
    }
    /**
     * Set AffectedInterchange value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedInterchangeStructure[] $affectedInterchange
     * @return \StructType\AffectedCallStructure
     */
    public function setAffectedInterchange(array $affectedInterchange = array())
    {
        foreach ($affectedInterchange as $affectedCallStructureAffectedInterchangeItem) {
            // validation for constraint: itemType
            if (!$affectedCallStructureAffectedInterchangeItem instanceof \StructType\AffectedInterchangeStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedInterchange property can only contain items of \StructType\AffectedInterchangeStructure, "%s" given', is_object($affectedCallStructureAffectedInterchangeItem) ? get_class($affectedCallStructureAffectedInterchangeItem) : gettype($affectedCallStructureAffectedInterchangeItem)), __LINE__);
            }
        }
        $this->AffectedInterchange = $affectedInterchange;
        return $this;
    }
    /**
     * Add item to AffectedInterchange value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedInterchangeStructure $item
     * @return \StructType\AffectedCallStructure
     */
    public function addToAffectedInterchange(\StructType\AffectedInterchangeStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedInterchangeStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedInterchange property can only contain items of \StructType\AffectedInterchangeStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedInterchange[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffectedCallStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
