<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdministrativeAreaRefsStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for a collection of one or more references to ADMINISTRATIVE ZONEs.
 * @subpackage Structs
 */
class AdministrativeAreaRefsStructure extends AbstractStructBase
{
    /**
     * The AdministrativeAreaRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to the identifier of an ADMINISTRATIVE ZONE.
     * - maxOccurs: unbounded
     * @var \StructType\AdministrativeAreaVersionedRefStructure[]
     */
    public $AdministrativeAreaRef;
    /**
     * Constructor method for AdministrativeAreaRefsStructure
     * @uses AdministrativeAreaRefsStructure::setAdministrativeAreaRef()
     * @param \StructType\AdministrativeAreaVersionedRefStructure[] $administrativeAreaRef
     */
    public function __construct(array $administrativeAreaRef = array())
    {
        $this
            ->setAdministrativeAreaRef($administrativeAreaRef);
    }
    /**
     * Get AdministrativeAreaRef value
     * @return \StructType\AdministrativeAreaVersionedRefStructure[]|null
     */
    public function getAdministrativeAreaRef()
    {
        return $this->AdministrativeAreaRef;
    }
    /**
     * Set AdministrativeAreaRef value
     * @throws \InvalidArgumentException
     * @param \StructType\AdministrativeAreaVersionedRefStructure[] $administrativeAreaRef
     * @return \StructType\AdministrativeAreaRefsStructure
     */
    public function setAdministrativeAreaRef(array $administrativeAreaRef = array())
    {
        foreach ($administrativeAreaRef as $administrativeAreaRefsStructureAdministrativeAreaRefItem) {
            // validation for constraint: itemType
            if (!$administrativeAreaRefsStructureAdministrativeAreaRefItem instanceof \StructType\AdministrativeAreaVersionedRefStructure) {
                throw new \InvalidArgumentException(sprintf('The AdministrativeAreaRef property can only contain items of \StructType\AdministrativeAreaVersionedRefStructure, "%s" given', is_object($administrativeAreaRefsStructureAdministrativeAreaRefItem) ? get_class($administrativeAreaRefsStructureAdministrativeAreaRefItem) : gettype($administrativeAreaRefsStructureAdministrativeAreaRefItem)), __LINE__);
            }
        }
        $this->AdministrativeAreaRef = $administrativeAreaRef;
        return $this;
    }
    /**
     * Add item to AdministrativeAreaRef value
     * @throws \InvalidArgumentException
     * @param \StructType\AdministrativeAreaVersionedRefStructure $item
     * @return \StructType\AdministrativeAreaRefsStructure
     */
    public function addToAdministrativeAreaRef(\StructType\AdministrativeAreaVersionedRefStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdministrativeAreaVersionedRefStructure) {
            throw new \InvalidArgumentException(sprintf('The AdministrativeAreaRef property can only contain items of \StructType\AdministrativeAreaVersionedRefStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdministrativeAreaRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdministrativeAreaRefsStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
