<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Activity StructType
 * @subpackage Structs
 */
abstract class Activity extends TrafficElement
{
    /**
     * The mobilityOfActivity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Mobility
     */
    public $mobilityOfActivity;
    /**
     * The activityExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $activityExtension;
    /**
     * Constructor method for Activity
     * @uses Activity::setMobilityOfActivity()
     * @uses Activity::setActivityExtension()
     * @param \StructType\Mobility $mobilityOfActivity
     * @param \StructType\ExtensionType $activityExtension
     */
    public function __construct(\StructType\Mobility $mobilityOfActivity = null, \StructType\ExtensionType $activityExtension = null)
    {
        $this
            ->setMobilityOfActivity($mobilityOfActivity)
            ->setActivityExtension($activityExtension);
    }
    /**
     * Get mobilityOfActivity value
     * @return \StructType\Mobility|null
     */
    public function getMobilityOfActivity()
    {
        return $this->mobilityOfActivity;
    }
    /**
     * Set mobilityOfActivity value
     * @param \StructType\Mobility $mobilityOfActivity
     * @return \StructType\Activity
     */
    public function setMobilityOfActivity(\StructType\Mobility $mobilityOfActivity = null)
    {
        $this->mobilityOfActivity = $mobilityOfActivity;
        return $this;
    }
    /**
     * Get activityExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getActivityExtension()
    {
        return $this->activityExtension;
    }
    /**
     * Set activityExtension value
     * @param \StructType\ExtensionType $activityExtension
     * @return \StructType\Activity
     */
    public function setActivityExtension(\StructType\ExtensionType $activityExtension = null)
    {
        $this->activityExtension = $activityExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Activity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
