<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessibilityLimitationStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for limitation on navigation.
 * @subpackage Structs
 */
class AccessibilityLimitationStructure extends AbstractStructBase
{
    /**
     * The LimitationId
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of LIMITATION. | Type for identifier of a hazard within a stop place.
     * - minOccurs: 0
     * @var string
     */
    public $LimitationId;
    /**
     * The ValidityCondition
     * Meta informations extracted from the WSDL
     * - documentation: Validty condition governing applicability of LIMITATION.
     * - minOccurs: 0
     * @var \StructType\ValidityConditionStructure
     */
    public $ValidityCondition;
    /**
     * The WheelchairAccess
     * @var \StructType\AccessibilityStructure
     */
    public $WheelchairAccess;
    /**
     * The StepFreeAccess
     * @var \StructType\AccessibilityStructure
     */
    public $StepFreeAccess;
    /**
     * The EscalatorFreeAccess
     * @var \StructType\AccessibilityStructure
     */
    public $EscalatorFreeAccess;
    /**
     * The LiftFreeAccess
     * @var \StructType\AccessibilityStructure
     */
    public $LiftFreeAccess;
    /**
     * The AudibleSignalsAvailable
     * @var \StructType\AccessibilityStructure
     */
    public $AudibleSignalsAvailable;
    /**
     * The VisualSignsAvailable
     * @var \StructType\AccessibilityStructure
     */
    public $VisualSignsAvailable;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ifopt:Extensions
     * @var \StructType\Extensions
     */
    public $Extensions;
    /**
     * Constructor method for AccessibilityLimitationStructure
     * @uses AccessibilityLimitationStructure::setLimitationId()
     * @uses AccessibilityLimitationStructure::setValidityCondition()
     * @uses AccessibilityLimitationStructure::setWheelchairAccess()
     * @uses AccessibilityLimitationStructure::setStepFreeAccess()
     * @uses AccessibilityLimitationStructure::setEscalatorFreeAccess()
     * @uses AccessibilityLimitationStructure::setLiftFreeAccess()
     * @uses AccessibilityLimitationStructure::setAudibleSignalsAvailable()
     * @uses AccessibilityLimitationStructure::setVisualSignsAvailable()
     * @uses AccessibilityLimitationStructure::setExtensions()
     * @param string $limitationId
     * @param \StructType\ValidityConditionStructure $validityCondition
     * @param \StructType\AccessibilityStructure $wheelchairAccess
     * @param \StructType\AccessibilityStructure $stepFreeAccess
     * @param \StructType\AccessibilityStructure $escalatorFreeAccess
     * @param \StructType\AccessibilityStructure $liftFreeAccess
     * @param \StructType\AccessibilityStructure $audibleSignalsAvailable
     * @param \StructType\AccessibilityStructure $visualSignsAvailable
     * @param \StructType\Extensions $extensions
     */
    public function __construct($limitationId = null, \StructType\ValidityConditionStructure $validityCondition = null, \StructType\AccessibilityStructure $wheelchairAccess = null, \StructType\AccessibilityStructure $stepFreeAccess = null, \StructType\AccessibilityStructure $escalatorFreeAccess = null, \StructType\AccessibilityStructure $liftFreeAccess = null, \StructType\AccessibilityStructure $audibleSignalsAvailable = null, \StructType\AccessibilityStructure $visualSignsAvailable = null, \StructType\Extensions $extensions = null)
    {
        $this
            ->setLimitationId($limitationId)
            ->setValidityCondition($validityCondition)
            ->setWheelchairAccess($wheelchairAccess)
            ->setStepFreeAccess($stepFreeAccess)
            ->setEscalatorFreeAccess($escalatorFreeAccess)
            ->setLiftFreeAccess($liftFreeAccess)
            ->setAudibleSignalsAvailable($audibleSignalsAvailable)
            ->setVisualSignsAvailable($visualSignsAvailable)
            ->setExtensions($extensions);
    }
    /**
     * Get LimitationId value
     * @return string|null
     */
    public function getLimitationId()
    {
        return $this->LimitationId;
    }
    /**
     * Set LimitationId value
     * @param string $limitationId
     * @return \StructType\AccessibilityLimitationStructure
     */
    public function setLimitationId($limitationId = null)
    {
        // validation for constraint: string
        if (!is_null($limitationId) && !is_string($limitationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($limitationId)), __LINE__);
        }
        $this->LimitationId = $limitationId;
        return $this;
    }
    /**
     * Get ValidityCondition value
     * @return \StructType\ValidityConditionStructure|null
     */
    public function getValidityCondition()
    {
        return $this->ValidityCondition;
    }
    /**
     * Set ValidityCondition value
     * @param \StructType\ValidityConditionStructure $validityCondition
     * @return \StructType\AccessibilityLimitationStructure
     */
    public function setValidityCondition(\StructType\ValidityConditionStructure $validityCondition = null)
    {
        $this->ValidityCondition = $validityCondition;
        return $this;
    }
    /**
     * Get WheelchairAccess value
     * @return \StructType\AccessibilityStructure|null
     */
    public function getWheelchairAccess()
    {
        return $this->WheelchairAccess;
    }
    /**
     * Set WheelchairAccess value
     * @param \StructType\AccessibilityStructure $wheelchairAccess
     * @return \StructType\AccessibilityLimitationStructure
     */
    public function setWheelchairAccess(\StructType\AccessibilityStructure $wheelchairAccess = null)
    {
        $this->WheelchairAccess = $wheelchairAccess;
        return $this;
    }
    /**
     * Get StepFreeAccess value
     * @return \StructType\AccessibilityStructure|null
     */
    public function getStepFreeAccess()
    {
        return $this->StepFreeAccess;
    }
    /**
     * Set StepFreeAccess value
     * @param \StructType\AccessibilityStructure $stepFreeAccess
     * @return \StructType\AccessibilityLimitationStructure
     */
    public function setStepFreeAccess(\StructType\AccessibilityStructure $stepFreeAccess = null)
    {
        $this->StepFreeAccess = $stepFreeAccess;
        return $this;
    }
    /**
     * Get EscalatorFreeAccess value
     * @return \StructType\AccessibilityStructure|null
     */
    public function getEscalatorFreeAccess()
    {
        return $this->EscalatorFreeAccess;
    }
    /**
     * Set EscalatorFreeAccess value
     * @param \StructType\AccessibilityStructure $escalatorFreeAccess
     * @return \StructType\AccessibilityLimitationStructure
     */
    public function setEscalatorFreeAccess(\StructType\AccessibilityStructure $escalatorFreeAccess = null)
    {
        $this->EscalatorFreeAccess = $escalatorFreeAccess;
        return $this;
    }
    /**
     * Get LiftFreeAccess value
     * @return \StructType\AccessibilityStructure|null
     */
    public function getLiftFreeAccess()
    {
        return $this->LiftFreeAccess;
    }
    /**
     * Set LiftFreeAccess value
     * @param \StructType\AccessibilityStructure $liftFreeAccess
     * @return \StructType\AccessibilityLimitationStructure
     */
    public function setLiftFreeAccess(\StructType\AccessibilityStructure $liftFreeAccess = null)
    {
        $this->LiftFreeAccess = $liftFreeAccess;
        return $this;
    }
    /**
     * Get AudibleSignalsAvailable value
     * @return \StructType\AccessibilityStructure|null
     */
    public function getAudibleSignalsAvailable()
    {
        return $this->AudibleSignalsAvailable;
    }
    /**
     * Set AudibleSignalsAvailable value
     * @param \StructType\AccessibilityStructure $audibleSignalsAvailable
     * @return \StructType\AccessibilityLimitationStructure
     */
    public function setAudibleSignalsAvailable(\StructType\AccessibilityStructure $audibleSignalsAvailable = null)
    {
        $this->AudibleSignalsAvailable = $audibleSignalsAvailable;
        return $this;
    }
    /**
     * Get VisualSignsAvailable value
     * @return \StructType\AccessibilityStructure|null
     */
    public function getVisualSignsAvailable()
    {
        return $this->VisualSignsAvailable;
    }
    /**
     * Set VisualSignsAvailable value
     * @param \StructType\AccessibilityStructure $visualSignsAvailable
     * @return \StructType\AccessibilityLimitationStructure
     */
    public function setVisualSignsAvailable(\StructType\AccessibilityStructure $visualSignsAvailable = null)
    {
        $this->VisualSignsAvailable = $visualSignsAvailable;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\Extensions|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\Extensions $extensions
     * @return \StructType\AccessibilityLimitationStructure
     */
    public function setExtensions(\StructType\Extensions $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccessibilityLimitationStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
