<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl StructType
 * Meta informations extracted from the WSDL
 * - documentation: Access control that can be used. | Optional Access control capabilities. | Optional Access control capabilities. | Optional Access control capabilities.
 * @subpackage Structs
 */
class AccessControl extends CapabilityAccessControlStructure
{
    /**
     * The CheckOperatorRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: CheckOperatorRef
     * @var bool
     */
    public $CheckOperatorRef;
    /**
     * The CheckLineRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: CheckLineRef
     * @var bool
     */
    public $CheckLineRef;
    /**
     * The CheckMonitoringRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: CheckMonitoringRef
     * @var bool
     */
    public $CheckMonitoringRef;
    /**
     * The CheckVehicleMonitoringRef
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: If access control is supported, whether access control by monitoring point is supported. Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $CheckVehicleMonitoringRef;
    /**
     * Constructor method for AccessControl
     * @uses AccessControl::setCheckOperatorRef()
     * @uses AccessControl::setCheckLineRef()
     * @uses AccessControl::setCheckMonitoringRef()
     * @uses AccessControl::setCheckVehicleMonitoringRef()
     * @param bool $checkOperatorRef
     * @param bool $checkLineRef
     * @param bool $checkMonitoringRef
     * @param bool $checkVehicleMonitoringRef
     */
    public function __construct($checkOperatorRef = null, $checkLineRef = null, $checkMonitoringRef = null, $checkVehicleMonitoringRef = true)
    {
        $this
            ->setCheckOperatorRef($checkOperatorRef)
            ->setCheckLineRef($checkLineRef)
            ->setCheckMonitoringRef($checkMonitoringRef)
            ->setCheckVehicleMonitoringRef($checkVehicleMonitoringRef);
    }
    /**
     * Get CheckOperatorRef value
     * @return bool|null
     */
    public function getCheckOperatorRef()
    {
        return $this->CheckOperatorRef;
    }
    /**
     * Set CheckOperatorRef value
     * @param bool $checkOperatorRef
     * @return \StructType\AccessControl
     */
    public function setCheckOperatorRef($checkOperatorRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkOperatorRef) && !is_bool($checkOperatorRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($checkOperatorRef)), __LINE__);
        }
        $this->CheckOperatorRef = $checkOperatorRef;
        return $this;
    }
    /**
     * Get CheckLineRef value
     * @return bool|null
     */
    public function getCheckLineRef()
    {
        return $this->CheckLineRef;
    }
    /**
     * Set CheckLineRef value
     * @param bool $checkLineRef
     * @return \StructType\AccessControl
     */
    public function setCheckLineRef($checkLineRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkLineRef) && !is_bool($checkLineRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($checkLineRef)), __LINE__);
        }
        $this->CheckLineRef = $checkLineRef;
        return $this;
    }
    /**
     * Get CheckMonitoringRef value
     * @return bool|null
     */
    public function getCheckMonitoringRef()
    {
        return $this->CheckMonitoringRef;
    }
    /**
     * Set CheckMonitoringRef value
     * @param bool $checkMonitoringRef
     * @return \StructType\AccessControl
     */
    public function setCheckMonitoringRef($checkMonitoringRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkMonitoringRef) && !is_bool($checkMonitoringRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($checkMonitoringRef)), __LINE__);
        }
        $this->CheckMonitoringRef = $checkMonitoringRef;
        return $this;
    }
    /**
     * Get CheckVehicleMonitoringRef value
     * @return bool|null
     */
    public function getCheckVehicleMonitoringRef()
    {
        return $this->CheckVehicleMonitoringRef;
    }
    /**
     * Set CheckVehicleMonitoringRef value
     * @param bool $checkVehicleMonitoringRef
     * @return \StructType\AccessControl
     */
    public function setCheckVehicleMonitoringRef($checkVehicleMonitoringRef = true)
    {
        // validation for constraint: boolean
        if (!is_null($checkVehicleMonitoringRef) && !is_bool($checkVehicleMonitoringRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($checkVehicleMonitoringRef)), __LINE__);
        }
        $this->CheckVehicleMonitoringRef = $checkVehicleMonitoringRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccessControl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
