<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractSubscriptionStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for SIRI Service subscriptions.
 * @subpackage Structs
 */
abstract class AbstractSubscriptionStructure extends AbstractStructBase
{
    /**
     * The SubscriberRef
     * @var \StructType\ParticipantRefStructure
     */
    public $SubscriberRef;
    /**
     * The SubscriptionIdentifier
     * @var \StructType\SubscriptionQualifierStructure
     */
    public $SubscriptionIdentifier;
    /**
     * The InitialTerminationTime
     * Meta informations extracted from the WSDL
     * - documentation: Requested end time for subscription.
     * @var string
     */
    public $InitialTerminationTime;
    /**
     * Constructor method for AbstractSubscriptionStructure
     * @uses AbstractSubscriptionStructure::setSubscriberRef()
     * @uses AbstractSubscriptionStructure::setSubscriptionIdentifier()
     * @uses AbstractSubscriptionStructure::setInitialTerminationTime()
     * @param \StructType\ParticipantRefStructure $subscriberRef
     * @param \StructType\SubscriptionQualifierStructure $subscriptionIdentifier
     * @param string $initialTerminationTime
     */
    public function __construct(\StructType\ParticipantRefStructure $subscriberRef = null, \StructType\SubscriptionQualifierStructure $subscriptionIdentifier = null, $initialTerminationTime = null)
    {
        $this
            ->setSubscriberRef($subscriberRef)
            ->setSubscriptionIdentifier($subscriptionIdentifier)
            ->setInitialTerminationTime($initialTerminationTime);
    }
    /**
     * Get SubscriberRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getSubscriberRef()
    {
        return $this->SubscriberRef;
    }
    /**
     * Set SubscriberRef value
     * @param \StructType\ParticipantRefStructure $subscriberRef
     * @return \StructType\AbstractSubscriptionStructure
     */
    public function setSubscriberRef(\StructType\ParticipantRefStructure $subscriberRef = null)
    {
        $this->SubscriberRef = $subscriberRef;
        return $this;
    }
    /**
     * Get SubscriptionIdentifier value
     * @return \StructType\SubscriptionQualifierStructure|null
     */
    public function getSubscriptionIdentifier()
    {
        return $this->SubscriptionIdentifier;
    }
    /**
     * Set SubscriptionIdentifier value
     * @param \StructType\SubscriptionQualifierStructure $subscriptionIdentifier
     * @return \StructType\AbstractSubscriptionStructure
     */
    public function setSubscriptionIdentifier(\StructType\SubscriptionQualifierStructure $subscriptionIdentifier = null)
    {
        $this->SubscriptionIdentifier = $subscriptionIdentifier;
        return $this;
    }
    /**
     * Get InitialTerminationTime value
     * @return string|null
     */
    public function getInitialTerminationTime()
    {
        return $this->InitialTerminationTime;
    }
    /**
     * Set InitialTerminationTime value
     * @param string $initialTerminationTime
     * @return \StructType\AbstractSubscriptionStructure
     */
    public function setInitialTerminationTime($initialTerminationTime = null)
    {
        // validation for constraint: string
        if (!is_null($initialTerminationTime) && !is_string($initialTerminationTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($initialTerminationTime)), __LINE__);
        }
        $this->InitialTerminationTime = $initialTerminationTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractSubscriptionStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
