<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractServiceCapabilitiesResponseStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for capabilities response. | If request has been proxied by an intermediate aggregting system, trackng informattion relating to the original requestor. This allows the aggregation to be stateless.
 * @subpackage Structs
 */
class AbstractServiceCapabilitiesResponseStructure extends ResponseStructure
{
    /**
     * The RequestMessageRef
     * @var \StructType\MessageQualifierStructure
     */
    public $RequestMessageRef;
    /**
     * The DelegatorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $DelegatorAddress;
    /**
     * The DelegatorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $DelegatorRef;
    /**
     * The Status
     * @var bool
     */
    public $Status;
    /**
     * The ErrorCondition
     * @var \StructType\ServiceDeliveryErrorConditionStructure
     */
    public $ErrorCondition;
    /**
     * Constructor method for AbstractServiceCapabilitiesResponseStructure
     * @uses AbstractServiceCapabilitiesResponseStructure::setRequestMessageRef()
     * @uses AbstractServiceCapabilitiesResponseStructure::setDelegatorAddress()
     * @uses AbstractServiceCapabilitiesResponseStructure::setDelegatorRef()
     * @uses AbstractServiceCapabilitiesResponseStructure::setStatus()
     * @uses AbstractServiceCapabilitiesResponseStructure::setErrorCondition()
     * @param \StructType\MessageQualifierStructure $requestMessageRef
     * @param string $delegatorAddress
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @param bool $status
     * @param \StructType\ServiceDeliveryErrorConditionStructure $errorCondition
     */
    public function __construct(\StructType\MessageQualifierStructure $requestMessageRef = null, $delegatorAddress = null, \StructType\ParticipantRefStructure $delegatorRef = null, $status = null, \StructType\ServiceDeliveryErrorConditionStructure $errorCondition = null)
    {
        $this
            ->setRequestMessageRef($requestMessageRef)
            ->setDelegatorAddress($delegatorAddress)
            ->setDelegatorRef($delegatorRef)
            ->setStatus($status)
            ->setErrorCondition($errorCondition);
    }
    /**
     * Get RequestMessageRef value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getRequestMessageRef()
    {
        return $this->RequestMessageRef;
    }
    /**
     * Set RequestMessageRef value
     * @param \StructType\MessageQualifierStructure $requestMessageRef
     * @return \StructType\AbstractServiceCapabilitiesResponseStructure
     */
    public function setRequestMessageRef(\StructType\MessageQualifierStructure $requestMessageRef = null)
    {
        $this->RequestMessageRef = $requestMessageRef;
        return $this;
    }
    /**
     * Get DelegatorAddress value
     * @return string|null
     */
    public function getDelegatorAddress()
    {
        return $this->DelegatorAddress;
    }
    /**
     * Set DelegatorAddress value
     * @param string $delegatorAddress
     * @return \StructType\AbstractServiceCapabilitiesResponseStructure
     */
    public function setDelegatorAddress($delegatorAddress = null)
    {
        // validation for constraint: string
        if (!is_null($delegatorAddress) && !is_string($delegatorAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delegatorAddress)), __LINE__);
        }
        $this->DelegatorAddress = $delegatorAddress;
        return $this;
    }
    /**
     * Get DelegatorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getDelegatorRef()
    {
        return $this->DelegatorRef;
    }
    /**
     * Set DelegatorRef value
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @return \StructType\AbstractServiceCapabilitiesResponseStructure
     */
    public function setDelegatorRef(\StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this->DelegatorRef = $delegatorRef;
        return $this;
    }
    /**
     * Get Status value
     * @return bool|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return \StructType\AbstractServiceCapabilitiesResponseStructure
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ErrorCondition value
     * @return \StructType\ServiceDeliveryErrorConditionStructure|null
     */
    public function getErrorCondition()
    {
        return $this->ErrorCondition;
    }
    /**
     * Set ErrorCondition value
     * @param \StructType\ServiceDeliveryErrorConditionStructure $errorCondition
     * @return \StructType\AbstractServiceCapabilitiesResponseStructure
     */
    public function setErrorCondition(\StructType\ServiceDeliveryErrorConditionStructure $errorCondition = null)
    {
        $this->ErrorCondition = $errorCondition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractServiceCapabilitiesResponseStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
