<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractItemStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for an Activity.
 * @subpackage Structs
 */
abstract class AbstractItemStructure extends AbstractStructBase
{
    /**
     * The RecordedAtTime
     * Meta informations extracted from the WSDL
     * - documentation: Time at which data was recorded.
     * @var string
     */
    public $RecordedAtTime;
    /**
     * Constructor method for AbstractItemStructure
     * @uses AbstractItemStructure::setRecordedAtTime()
     * @param string $recordedAtTime
     */
    public function __construct($recordedAtTime = null)
    {
        $this
            ->setRecordedAtTime($recordedAtTime);
    }
    /**
     * Get RecordedAtTime value
     * @return string|null
     */
    public function getRecordedAtTime()
    {
        return $this->RecordedAtTime;
    }
    /**
     * Set RecordedAtTime value
     * @param string $recordedAtTime
     * @return \StructType\AbstractItemStructure
     */
    public function setRecordedAtTime($recordedAtTime = null)
    {
        // validation for constraint: string
        if (!is_null($recordedAtTime) && !is_string($recordedAtTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recordedAtTime)), __LINE__);
        }
        $this->RecordedAtTime = $recordedAtTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractItemStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
