<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractFeederItemStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for an SERVICE JOURNEY INTERCHANGE feeder Activity.
 * @subpackage Structs
 */
abstract class AbstractFeederItemStructure extends AbstractIdentifiedItemStructure
{
    /**
     * The ValidUntilTime
     * Meta informations extracted from the WSDL
     * - documentation: Time until when data is valid. +SIRI 2.0
     * - minOccurs: 0
     * @var string
     */
    public $ValidUntilTime;
    /**
     * The InterchangeRef
     * @var \StructType\InterchangeRefStructure
     */
    public $InterchangeRef;
    /**
     * The ConnectionLinkRef
     * @var \StructType\ConnectionLinkRefStructure
     */
    public $ConnectionLinkRef;
    /**
     * The StopPointRef
     * @var \StructType\StopPointRefStructure
     */
    public $StopPointRef;
    /**
     * The VisitNumber
     * Meta informations extracted from the WSDL
     * - documentation: Type for Stop Visit.
     * @var int
     */
    public $VisitNumber;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The StopPointName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $StopPointName;
    /**
     * Constructor method for AbstractFeederItemStructure
     * @uses AbstractFeederItemStructure::setValidUntilTime()
     * @uses AbstractFeederItemStructure::setInterchangeRef()
     * @uses AbstractFeederItemStructure::setConnectionLinkRef()
     * @uses AbstractFeederItemStructure::setStopPointRef()
     * @uses AbstractFeederItemStructure::setVisitNumber()
     * @uses AbstractFeederItemStructure::setOrder()
     * @uses AbstractFeederItemStructure::setStopPointName()
     * @param string $validUntilTime
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @param int $visitNumber
     * @param int $order
     * @param \StructType\NaturalLanguageStringStructure $stopPointName
     */
    public function __construct($validUntilTime = null, \StructType\InterchangeRefStructure $interchangeRef = null, \StructType\ConnectionLinkRefStructure $connectionLinkRef = null, \StructType\StopPointRefStructure $stopPointRef = null, $visitNumber = null, $order = null, \StructType\NaturalLanguageStringStructure $stopPointName = null)
    {
        $this
            ->setValidUntilTime($validUntilTime)
            ->setInterchangeRef($interchangeRef)
            ->setConnectionLinkRef($connectionLinkRef)
            ->setStopPointRef($stopPointRef)
            ->setVisitNumber($visitNumber)
            ->setOrder($order)
            ->setStopPointName($stopPointName);
    }
    /**
     * Get ValidUntilTime value
     * @return string|null
     */
    public function getValidUntilTime()
    {
        return $this->ValidUntilTime;
    }
    /**
     * Set ValidUntilTime value
     * @param string $validUntilTime
     * @return \StructType\AbstractFeederItemStructure
     */
    public function setValidUntilTime($validUntilTime = null)
    {
        // validation for constraint: string
        if (!is_null($validUntilTime) && !is_string($validUntilTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validUntilTime)), __LINE__);
        }
        $this->ValidUntilTime = $validUntilTime;
        return $this;
    }
    /**
     * Get InterchangeRef value
     * @return \StructType\InterchangeRefStructure|null
     */
    public function getInterchangeRef()
    {
        return $this->InterchangeRef;
    }
    /**
     * Set InterchangeRef value
     * @param \StructType\InterchangeRefStructure $interchangeRef
     * @return \StructType\AbstractFeederItemStructure
     */
    public function setInterchangeRef(\StructType\InterchangeRefStructure $interchangeRef = null)
    {
        $this->InterchangeRef = $interchangeRef;
        return $this;
    }
    /**
     * Get ConnectionLinkRef value
     * @return \StructType\ConnectionLinkRefStructure|null
     */
    public function getConnectionLinkRef()
    {
        return $this->ConnectionLinkRef;
    }
    /**
     * Set ConnectionLinkRef value
     * @param \StructType\ConnectionLinkRefStructure $connectionLinkRef
     * @return \StructType\AbstractFeederItemStructure
     */
    public function setConnectionLinkRef(\StructType\ConnectionLinkRefStructure $connectionLinkRef = null)
    {
        $this->ConnectionLinkRef = $connectionLinkRef;
        return $this;
    }
    /**
     * Get StopPointRef value
     * @return \StructType\StopPointRefStructure|null
     */
    public function getStopPointRef()
    {
        return $this->StopPointRef;
    }
    /**
     * Set StopPointRef value
     * @param \StructType\StopPointRefStructure $stopPointRef
     * @return \StructType\AbstractFeederItemStructure
     */
    public function setStopPointRef(\StructType\StopPointRefStructure $stopPointRef = null)
    {
        $this->StopPointRef = $stopPointRef;
        return $this;
    }
    /**
     * Get VisitNumber value
     * @return int|null
     */
    public function getVisitNumber()
    {
        return $this->VisitNumber;
    }
    /**
     * Set VisitNumber value
     * @param int $visitNumber
     * @return \StructType\AbstractFeederItemStructure
     */
    public function setVisitNumber($visitNumber = null)
    {
        // validation for constraint: int
        if (!is_null($visitNumber) && !is_numeric($visitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($visitNumber)), __LINE__);
        }
        $this->VisitNumber = $visitNumber;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\AbstractFeederItemStructure
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get StopPointName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getStopPointName()
    {
        return $this->StopPointName;
    }
    /**
     * Set StopPointName value
     * @param \StructType\NaturalLanguageStringStructure $stopPointName
     * @return \StructType\AbstractFeederItemStructure
     */
    public function setStopPointName(\StructType\NaturalLanguageStringStructure $stopPointName = null)
    {
        $this->StopPointName = $stopPointName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractFeederItemStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
