<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractEquipmentStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for abstract EQUIPMENT.
 * @subpackage Structs
 */
abstract class AbstractEquipmentStructure extends DataManagedObjectStructure
{
    /**
     * The EquipmentId
     * Meta informations extracted from the WSDL
     * - documentation: Type for identifier of EQUIPMENT.
     * @var string
     */
    public $EquipmentId;
    /**
     * The EquipmentName
     * @var \StructType\NaturalLanguageStringStructure
     */
    public $EquipmentName;
    /**
     * The TypeOfEquipment
     * @var \StructType\EquipmentTypeRefStructure
     */
    public $TypeOfEquipment;
    /**
     * Constructor method for AbstractEquipmentStructure
     * @uses AbstractEquipmentStructure::setEquipmentId()
     * @uses AbstractEquipmentStructure::setEquipmentName()
     * @uses AbstractEquipmentStructure::setTypeOfEquipment()
     * @param string $equipmentId
     * @param \StructType\NaturalLanguageStringStructure $equipmentName
     * @param \StructType\EquipmentTypeRefStructure $typeOfEquipment
     */
    public function __construct($equipmentId = null, \StructType\NaturalLanguageStringStructure $equipmentName = null, \StructType\EquipmentTypeRefStructure $typeOfEquipment = null)
    {
        $this
            ->setEquipmentId($equipmentId)
            ->setEquipmentName($equipmentName)
            ->setTypeOfEquipment($typeOfEquipment);
    }
    /**
     * Get EquipmentId value
     * @return string|null
     */
    public function getEquipmentId()
    {
        return $this->EquipmentId;
    }
    /**
     * Set EquipmentId value
     * @param string $equipmentId
     * @return \StructType\AbstractEquipmentStructure
     */
    public function setEquipmentId($equipmentId = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentId) && !is_string($equipmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipmentId)), __LINE__);
        }
        $this->EquipmentId = $equipmentId;
        return $this;
    }
    /**
     * Get EquipmentName value
     * @return \StructType\NaturalLanguageStringStructure|null
     */
    public function getEquipmentName()
    {
        return $this->EquipmentName;
    }
    /**
     * Set EquipmentName value
     * @param \StructType\NaturalLanguageStringStructure $equipmentName
     * @return \StructType\AbstractEquipmentStructure
     */
    public function setEquipmentName(\StructType\NaturalLanguageStringStructure $equipmentName = null)
    {
        $this->EquipmentName = $equipmentName;
        return $this;
    }
    /**
     * Get TypeOfEquipment value
     * @return \StructType\EquipmentTypeRefStructure|null
     */
    public function getTypeOfEquipment()
    {
        return $this->TypeOfEquipment;
    }
    /**
     * Set TypeOfEquipment value
     * @param \StructType\EquipmentTypeRefStructure $typeOfEquipment
     * @return \StructType\AbstractEquipmentStructure
     */
    public function setTypeOfEquipment(\StructType\EquipmentTypeRefStructure $typeOfEquipment = null)
    {
        $this->TypeOfEquipment = $typeOfEquipment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractEquipmentStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
