<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractDiscoveryRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Requests for stop reference data for use in service requests.
 * @subpackage Structs
 */
abstract class AbstractDiscoveryRequestStructure extends AuthenticatedRequestStructure
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $Address;
    /**
     * The RequestorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $RequestorRef;
    /**
     * The MessageIdentifier
     * @var \StructType\MessageQualifierStructure
     */
    public $MessageIdentifier;
    /**
     * Constructor method for AbstractDiscoveryRequestStructure
     * @uses AbstractDiscoveryRequestStructure::setAddress()
     * @uses AbstractDiscoveryRequestStructure::setRequestorRef()
     * @uses AbstractDiscoveryRequestStructure::setMessageIdentifier()
     * @param string $address
     * @param \StructType\ParticipantRefStructure $requestorRef
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     */
    public function __construct($address = null, \StructType\ParticipantRefStructure $requestorRef = null, \StructType\MessageQualifierStructure $messageIdentifier = null)
    {
        $this
            ->setAddress($address)
            ->setRequestorRef($requestorRef)
            ->setMessageIdentifier($messageIdentifier);
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\AbstractDiscoveryRequestStructure
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get RequestorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getRequestorRef()
    {
        return $this->RequestorRef;
    }
    /**
     * Set RequestorRef value
     * @param \StructType\ParticipantRefStructure $requestorRef
     * @return \StructType\AbstractDiscoveryRequestStructure
     */
    public function setRequestorRef(\StructType\ParticipantRefStructure $requestorRef = null)
    {
        $this->RequestorRef = $requestorRef;
        return $this;
    }
    /**
     * Get MessageIdentifier value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getMessageIdentifier()
    {
        return $this->MessageIdentifier;
    }
    /**
     * Set MessageIdentifier value
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     * @return \StructType\AbstractDiscoveryRequestStructure
     */
    public function setMessageIdentifier(\StructType\MessageQualifierStructure $messageIdentifier = null)
    {
        $this->MessageIdentifier = $messageIdentifier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractDiscoveryRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
