<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractDiscoveryDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Abstract supertype fro discovery responses.
 * @subpackage Structs
 */
class AbstractDiscoveryDeliveryStructure extends ResponseStructure
{
    /**
     * The Status
     * @var bool
     */
    public $Status;
    /**
     * The ErrorCondition
     * @var \StructType\ServiceDeliveryErrorConditionStructure
     */
    public $ErrorCondition;
    /**
     * The ValidUntil
     * @var string
     */
    public $ValidUntil;
    /**
     * The ShortestPossibleCycle
     * Meta informations extracted from the WSDL
     * - documentation: Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute Second terms should be used. Milliseconds should not be used. Year should not be
     * used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * @var string
     */
    public $ShortestPossibleCycle;
    /**
     * Constructor method for AbstractDiscoveryDeliveryStructure
     * @uses AbstractDiscoveryDeliveryStructure::setStatus()
     * @uses AbstractDiscoveryDeliveryStructure::setErrorCondition()
     * @uses AbstractDiscoveryDeliveryStructure::setValidUntil()
     * @uses AbstractDiscoveryDeliveryStructure::setShortestPossibleCycle()
     * @param bool $status
     * @param \StructType\ServiceDeliveryErrorConditionStructure $errorCondition
     * @param string $validUntil
     * @param string $shortestPossibleCycle
     */
    public function __construct($status = null, \StructType\ServiceDeliveryErrorConditionStructure $errorCondition = null, $validUntil = null, $shortestPossibleCycle = null)
    {
        $this
            ->setStatus($status)
            ->setErrorCondition($errorCondition)
            ->setValidUntil($validUntil)
            ->setShortestPossibleCycle($shortestPossibleCycle);
    }
    /**
     * Get Status value
     * @return bool|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return \StructType\AbstractDiscoveryDeliveryStructure
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ErrorCondition value
     * @return \StructType\ServiceDeliveryErrorConditionStructure|null
     */
    public function getErrorCondition()
    {
        return $this->ErrorCondition;
    }
    /**
     * Set ErrorCondition value
     * @param \StructType\ServiceDeliveryErrorConditionStructure $errorCondition
     * @return \StructType\AbstractDiscoveryDeliveryStructure
     */
    public function setErrorCondition(\StructType\ServiceDeliveryErrorConditionStructure $errorCondition = null)
    {
        $this->ErrorCondition = $errorCondition;
        return $this;
    }
    /**
     * Get ValidUntil value
     * @return string|null
     */
    public function getValidUntil()
    {
        return $this->ValidUntil;
    }
    /**
     * Set ValidUntil value
     * @param string $validUntil
     * @return \StructType\AbstractDiscoveryDeliveryStructure
     */
    public function setValidUntil($validUntil = null)
    {
        // validation for constraint: string
        if (!is_null($validUntil) && !is_string($validUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validUntil)), __LINE__);
        }
        $this->ValidUntil = $validUntil;
        return $this;
    }
    /**
     * Get ShortestPossibleCycle value
     * @return string|null
     */
    public function getShortestPossibleCycle()
    {
        return $this->ShortestPossibleCycle;
    }
    /**
     * Set ShortestPossibleCycle value
     * @param string $shortestPossibleCycle
     * @return \StructType\AbstractDiscoveryDeliveryStructure
     */
    public function setShortestPossibleCycle($shortestPossibleCycle = null)
    {
        // validation for constraint: string
        if (!is_null($shortestPossibleCycle) && !is_string($shortestPossibleCycle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortestPossibleCycle)), __LINE__);
        }
        $this->ShortestPossibleCycle = $shortestPossibleCycle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractDiscoveryDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
