<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetProductionTimetable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WsServiceRequestInfoStructure $serviceRequestInfo
     * @param \StructType\ProductionTimetableRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function GetProductionTimetable(\StructType\WsServiceRequestInfoStructure $serviceRequestInfo, \StructType\ProductionTimetableRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProductionTimetable($serviceRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEstimatedTimetable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WsServiceRequestInfoStructure $serviceRequestInfo
     * @param \StructType\EstimatedTimetableRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function GetEstimatedTimetable(\StructType\WsServiceRequestInfoStructure $serviceRequestInfo, \StructType\EstimatedTimetableRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEstimatedTimetable($serviceRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStopTimetable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WsServiceRequestInfoStructure $serviceRequestInfo
     * @param \StructType\StopTimetableRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function GetStopTimetable(\StructType\WsServiceRequestInfoStructure $serviceRequestInfo, \StructType\StopTimetableRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStopTimetable($serviceRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStopMonitoring
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WsServiceRequestInfoStructure $serviceRequestInfo
     * @param \StructType\StopMonitoringRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function GetStopMonitoring(\StructType\WsServiceRequestInfoStructure $serviceRequestInfo, \StructType\StopMonitoringRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStopMonitoring($serviceRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMultipleStopMonitoring
     * Meta informations extracted from the WSDL
     * - documentation: GetMultipleStopMonitoring deprecated from Siri 2.0 (use GetSiriService instead)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WsServiceRequestInfoStructure $serviceRequestInfo
     * @param \StructType\StopMonitoringMultipleRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function GetMultipleStopMonitoring(\StructType\WsServiceRequestInfoStructure $serviceRequestInfo, \StructType\StopMonitoringMultipleRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMultipleStopMonitoring($serviceRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVehicleMonitoring
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WsServiceRequestInfoStructure $serviceRequestInfo
     * @param \StructType\VehicleMonitoringRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function GetVehicleMonitoring(\StructType\WsServiceRequestInfoStructure $serviceRequestInfo, \StructType\VehicleMonitoringRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVehicleMonitoring($serviceRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConnectionTimetable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WsServiceRequestInfoStructure $serviceRequestInfo
     * @param \StructType\ConnectionTimetableRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function GetConnectionTimetable(\StructType\WsServiceRequestInfoStructure $serviceRequestInfo, \StructType\ConnectionTimetableRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->GetConnectionTimetable($serviceRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConnectionMonitoring
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WsServiceRequestInfoStructure $serviceRequestInfo
     * @param \StructType\ConnectionMonitoringRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function GetConnectionMonitoring(\StructType\WsServiceRequestInfoStructure $serviceRequestInfo, \StructType\ConnectionMonitoringRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->GetConnectionMonitoring($serviceRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGeneralMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WsServiceRequestInfoStructure $serviceRequestInfo
     * @param \StructType\GeneralMessageRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function GetGeneralMessage(\StructType\WsServiceRequestInfoStructure $serviceRequestInfo, \StructType\GeneralMessageRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGeneralMessage($serviceRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFacilityMonitoring
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WsServiceRequestInfoStructure $serviceRequestInfo
     * @param \StructType\FacilityMonitoringRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function GetFacilityMonitoring(\StructType\WsServiceRequestInfoStructure $serviceRequestInfo, \StructType\FacilityMonitoringRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFacilityMonitoring($serviceRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSituationExchange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WsServiceRequestInfoStructure $serviceRequestInfo
     * @param \StructType\SituationExchangeRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function GetSituationExchange(\StructType\WsServiceRequestInfoStructure $serviceRequestInfo, \StructType\SituationExchangeRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSituationExchange($serviceRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCapabilities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CapabilitiesRequestStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function GetCapabilities(\StructType\CapabilitiesRequestStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCapabilities($request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSiriService
     * Meta informations extracted from the WSDL
     * - documentation: SIRI 2.x : Single access to any SIRI Service
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ServiceRequestStructure $request
     * @return \StructType\ServiceDeliveryStructure|bool
     */
    public function GetSiriService(\StructType\ServiceRequestStructure $request)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSiriService($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array|\StructType\ServiceDeliveryStructure
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
