<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Data ServiceType
 * @subpackage Services
 */
class Data extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DataSupply
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsumerRequestEndpointStructure $dataSupplyRequestInfo
     * @param \StructType\DataSupplyRequestBodyStructure $request
     * @param \StructType\ExtensionsStructure $requestExtension
     * @return array|bool
     */
    public function DataSupply(\StructType\ConsumerRequestEndpointStructure $dataSupplyRequestInfo, \StructType\DataSupplyRequestBodyStructure $request, \StructType\ExtensionsStructure $requestExtension)
    {
        try {
            $this->setResult(self::getSoapClient()->DataSupply($dataSupplyRequestInfo, $request, $requestExtension));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
