<?php

namespace EnumType;

/**
 * This class stands for WinterEquipmentManagementTypeEnum EnumType
 * @subpackage Enumerations
 */
class WinterEquipmentManagementTypeEnum
{
    /**
     * Constant for value 'doNoUseStudTyres'
     * @return string 'doNoUseStudTyres'
     */
    const VALUE_DO_NO_USE_STUD_TYRES = 'doNoUseStudTyres';
    /**
     * Constant for value 'useSnowChains'
     * @return string 'useSnowChains'
     */
    const VALUE_USE_SNOW_CHAINS = 'useSnowChains';
    /**
     * Constant for value 'useSnowChainsOrTyres'
     * @return string 'useSnowChainsOrTyres'
     */
    const VALUE_USE_SNOW_CHAINS_OR_TYRES = 'useSnowChainsOrTyres';
    /**
     * Constant for value 'useSnowTyres'
     * @return string 'useSnowTyres'
     */
    const VALUE_USE_SNOW_TYRES = 'useSnowTyres';
    /**
     * Constant for value 'winterEquipmentOnBoardRequired'
     * @return string 'winterEquipmentOnBoardRequired'
     */
    const VALUE_WINTER_EQUIPMENT_ON_BOARD_REQUIRED = 'winterEquipmentOnBoardRequired';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DO_NO_USE_STUD_TYRES
     * @uses self::VALUE_USE_SNOW_CHAINS
     * @uses self::VALUE_USE_SNOW_CHAINS_OR_TYRES
     * @uses self::VALUE_USE_SNOW_TYRES
     * @uses self::VALUE_WINTER_EQUIPMENT_ON_BOARD_REQUIRED
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DO_NO_USE_STUD_TYRES,
            self::VALUE_USE_SNOW_CHAINS,
            self::VALUE_USE_SNOW_CHAINS_OR_TYRES,
            self::VALUE_USE_SNOW_TYRES,
            self::VALUE_WINTER_EQUIPMENT_ON_BOARD_REQUIRED,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
