<?php

namespace EnumType;

/**
 * This class stands for WeatherRelatedRoadConditionTypeEnum EnumType
 * @subpackage Enumerations
 */
class WeatherRelatedRoadConditionTypeEnum
{
    /**
     * Constant for value 'blackIce'
     * @return string 'blackIce'
     */
    const VALUE_BLACK_ICE = 'blackIce';
    /**
     * Constant for value 'deepSnow'
     * @return string 'deepSnow'
     */
    const VALUE_DEEP_SNOW = 'deepSnow';
    /**
     * Constant for value 'dry'
     * @return string 'dry'
     */
    const VALUE_DRY = 'dry';
    /**
     * Constant for value 'freezingOfWetRoads'
     * @return string 'freezingOfWetRoads'
     */
    const VALUE_FREEZING_OF_WET_ROADS = 'freezingOfWetRoads';
    /**
     * Constant for value 'freezingPavements'
     * @return string 'freezingPavements'
     */
    const VALUE_FREEZING_PAVEMENTS = 'freezingPavements';
    /**
     * Constant for value 'freezingRain'
     * @return string 'freezingRain'
     */
    const VALUE_FREEZING_RAIN = 'freezingRain';
    /**
     * Constant for value 'freshSnow'
     * @return string 'freshSnow'
     */
    const VALUE_FRESH_SNOW = 'freshSnow';
    /**
     * Constant for value 'ice'
     * @return string 'ice'
     */
    const VALUE_ICE = 'ice';
    /**
     * Constant for value 'iceBuildUp'
     * @return string 'iceBuildUp'
     */
    const VALUE_ICE_BUILD_UP = 'iceBuildUp';
    /**
     * Constant for value 'iceWithWheelBarTracks'
     * @return string 'iceWithWheelBarTracks'
     */
    const VALUE_ICE_WITH_WHEEL_BAR_TRACKS = 'iceWithWheelBarTracks';
    /**
     * Constant for value 'icyPatches'
     * @return string 'icyPatches'
     */
    const VALUE_ICY_PATCHES = 'icyPatches';
    /**
     * Constant for value 'looseSnow'
     * @return string 'looseSnow'
     */
    const VALUE_LOOSE_SNOW = 'looseSnow';
    /**
     * Constant for value 'normalWinterConditionsForPedestrians'
     * @return string 'normalWinterConditionsForPedestrians'
     */
    const VALUE_NORMAL_WINTER_CONDITIONS_FOR_PEDESTRIANS = 'normalWinterConditionsForPedestrians';
    /**
     * Constant for value 'packedSnow'
     * @return string 'packedSnow'
     */
    const VALUE_PACKED_SNOW = 'packedSnow';
    /**
     * Constant for value 'roadSurfaceMelting'
     * @return string 'roadSurfaceMelting'
     */
    const VALUE_ROAD_SURFACE_MELTING = 'roadSurfaceMelting';
    /**
     * Constant for value 'slipperyRoad'
     * @return string 'slipperyRoad'
     */
    const VALUE_SLIPPERY_ROAD = 'slipperyRoad';
    /**
     * Constant for value 'slushOnRoad'
     * @return string 'slushOnRoad'
     */
    const VALUE_SLUSH_ON_ROAD = 'slushOnRoad';
    /**
     * Constant for value 'slushStrings'
     * @return string 'slushStrings'
     */
    const VALUE_SLUSH_STRINGS = 'slushStrings';
    /**
     * Constant for value 'snowDrifts'
     * @return string 'snowDrifts'
     */
    const VALUE_SNOW_DRIFTS = 'snowDrifts';
    /**
     * Constant for value 'snowOnPavement'
     * @return string 'snowOnPavement'
     */
    const VALUE_SNOW_ON_PAVEMENT = 'snowOnPavement';
    /**
     * Constant for value 'snowOnTheRoad'
     * @return string 'snowOnTheRoad'
     */
    const VALUE_SNOW_ON_THE_ROAD = 'snowOnTheRoad';
    /**
     * Constant for value 'surfaceWater'
     * @return string 'surfaceWater'
     */
    const VALUE_SURFACE_WATER = 'surfaceWater';
    /**
     * Constant for value 'wet'
     * @return string 'wet'
     */
    const VALUE_WET = 'wet';
    /**
     * Constant for value 'wetAndIcyRoad'
     * @return string 'wetAndIcyRoad'
     */
    const VALUE_WET_AND_ICY_ROAD = 'wetAndIcyRoad';
    /**
     * Constant for value 'wetIcyPavement'
     * @return string 'wetIcyPavement'
     */
    const VALUE_WET_ICY_PAVEMENT = 'wetIcyPavement';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BLACK_ICE
     * @uses self::VALUE_DEEP_SNOW
     * @uses self::VALUE_DRY
     * @uses self::VALUE_FREEZING_OF_WET_ROADS
     * @uses self::VALUE_FREEZING_PAVEMENTS
     * @uses self::VALUE_FREEZING_RAIN
     * @uses self::VALUE_FRESH_SNOW
     * @uses self::VALUE_ICE
     * @uses self::VALUE_ICE_BUILD_UP
     * @uses self::VALUE_ICE_WITH_WHEEL_BAR_TRACKS
     * @uses self::VALUE_ICY_PATCHES
     * @uses self::VALUE_LOOSE_SNOW
     * @uses self::VALUE_NORMAL_WINTER_CONDITIONS_FOR_PEDESTRIANS
     * @uses self::VALUE_PACKED_SNOW
     * @uses self::VALUE_ROAD_SURFACE_MELTING
     * @uses self::VALUE_SLIPPERY_ROAD
     * @uses self::VALUE_SLUSH_ON_ROAD
     * @uses self::VALUE_SLUSH_STRINGS
     * @uses self::VALUE_SNOW_DRIFTS
     * @uses self::VALUE_SNOW_ON_PAVEMENT
     * @uses self::VALUE_SNOW_ON_THE_ROAD
     * @uses self::VALUE_SURFACE_WATER
     * @uses self::VALUE_WET
     * @uses self::VALUE_WET_AND_ICY_ROAD
     * @uses self::VALUE_WET_ICY_PAVEMENT
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BLACK_ICE,
            self::VALUE_DEEP_SNOW,
            self::VALUE_DRY,
            self::VALUE_FREEZING_OF_WET_ROADS,
            self::VALUE_FREEZING_PAVEMENTS,
            self::VALUE_FREEZING_RAIN,
            self::VALUE_FRESH_SNOW,
            self::VALUE_ICE,
            self::VALUE_ICE_BUILD_UP,
            self::VALUE_ICE_WITH_WHEEL_BAR_TRACKS,
            self::VALUE_ICY_PATCHES,
            self::VALUE_LOOSE_SNOW,
            self::VALUE_NORMAL_WINTER_CONDITIONS_FOR_PEDESTRIANS,
            self::VALUE_PACKED_SNOW,
            self::VALUE_ROAD_SURFACE_MELTING,
            self::VALUE_SLIPPERY_ROAD,
            self::VALUE_SLUSH_ON_ROAD,
            self::VALUE_SLUSH_STRINGS,
            self::VALUE_SNOW_DRIFTS,
            self::VALUE_SNOW_ON_PAVEMENT,
            self::VALUE_SNOW_ON_THE_ROAD,
            self::VALUE_SURFACE_WATER,
            self::VALUE_WET,
            self::VALUE_WET_AND_ICY_ROAD,
            self::VALUE_WET_ICY_PAVEMENT,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
