<?php

namespace EnumType;

/**
 * This class stands for VehicleUsageEnum EnumType
 * @subpackage Enumerations
 */
class VehicleUsageEnum
{
    /**
     * Constant for value 'agricultural'
     * @return string 'agricultural'
     */
    const VALUE_AGRICULTURAL = 'agricultural';
    /**
     * Constant for value 'commercial'
     * @return string 'commercial'
     */
    const VALUE_COMMERCIAL = 'commercial';
    /**
     * Constant for value 'emergencyServices'
     * @return string 'emergencyServices'
     */
    const VALUE_EMERGENCY_SERVICES = 'emergencyServices';
    /**
     * Constant for value 'military'
     * @return string 'military'
     */
    const VALUE_MILITARY = 'military';
    /**
     * Constant for value 'nonCommercial'
     * @return string 'nonCommercial'
     */
    const VALUE_NON_COMMERCIAL = 'nonCommercial';
    /**
     * Constant for value 'patrol'
     * @return string 'patrol'
     */
    const VALUE_PATROL = 'patrol';
    /**
     * Constant for value 'recoveryServices'
     * @return string 'recoveryServices'
     */
    const VALUE_RECOVERY_SERVICES = 'recoveryServices';
    /**
     * Constant for value 'roadMaintenanceOrConstruction'
     * @return string 'roadMaintenanceOrConstruction'
     */
    const VALUE_ROAD_MAINTENANCE_OR_CONSTRUCTION = 'roadMaintenanceOrConstruction';
    /**
     * Constant for value 'roadOperator'
     * @return string 'roadOperator'
     */
    const VALUE_ROAD_OPERATOR = 'roadOperator';
    /**
     * Constant for value 'taxi'
     * @return string 'taxi'
     */
    const VALUE_TAXI = 'taxi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AGRICULTURAL
     * @uses self::VALUE_COMMERCIAL
     * @uses self::VALUE_EMERGENCY_SERVICES
     * @uses self::VALUE_MILITARY
     * @uses self::VALUE_NON_COMMERCIAL
     * @uses self::VALUE_PATROL
     * @uses self::VALUE_RECOVERY_SERVICES
     * @uses self::VALUE_ROAD_MAINTENANCE_OR_CONSTRUCTION
     * @uses self::VALUE_ROAD_OPERATOR
     * @uses self::VALUE_TAXI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AGRICULTURAL,
            self::VALUE_COMMERCIAL,
            self::VALUE_EMERGENCY_SERVICES,
            self::VALUE_MILITARY,
            self::VALUE_NON_COMMERCIAL,
            self::VALUE_PATROL,
            self::VALUE_RECOVERY_SERVICES,
            self::VALUE_ROAD_MAINTENANCE_OR_CONSTRUCTION,
            self::VALUE_ROAD_OPERATOR,
            self::VALUE_TAXI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
