<?php

namespace EnumType;

/**
 * This class stands for VehicleStatusEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Classification of the State of the VEHICLE JORUNEY according to a fixed list of values. This may reflect a presentation policy, for example CALLs less than one minute behind target time are still classified as on-time. Applications
 * may use this to guide their own presentation of times.
 * @subpackage Enumerations
 */
class VehicleStatusEnumeration
{
    /**
     * Constant for value 'expected'
     * @return string 'expected'
     */
    const VALUE_EXPECTED = 'expected';
    /**
     * Constant for value 'notExpected'
     * @return string 'notExpected'
     */
    const VALUE_NOT_EXPECTED = 'notExpected';
    /**
     * Constant for value 'cancelled'
     * @return string 'cancelled'
     */
    const VALUE_CANCELLED = 'cancelled';
    /**
     * Constant for value 'assigned'
     * @return string 'assigned'
     */
    const VALUE_ASSIGNED = 'assigned';
    /**
     * Constant for value 'signedOn'
     * @return string 'signedOn'
     */
    const VALUE_SIGNED_ON = 'signedOn';
    /**
     * Constant for value 'atOrigin'
     * @return string 'atOrigin'
     */
    const VALUE_AT_ORIGIN = 'atOrigin';
    /**
     * Constant for value 'inProgress'
     * @return string 'inProgress'
     */
    const VALUE_IN_PROGRESS = 'inProgress';
    /**
     * Constant for value 'aborted'
     * @return string 'aborted'
     */
    const VALUE_ABORTED = 'aborted';
    /**
     * Constant for value 'offRoute'
     * @return string 'offRoute'
     */
    const VALUE_OFF_ROUTE = 'offRoute';
    /**
     * Constant for value 'completed'
     * @return string 'completed'
     */
    const VALUE_COMPLETED = 'completed';
    /**
     * Constant for value 'assumedCompleted'
     * @return string 'assumedCompleted'
     */
    const VALUE_ASSUMED_COMPLETED = 'assumedCompleted';
    /**
     * Constant for value 'notRun'
     * @return string 'notRun'
     */
    const VALUE_NOT_RUN = 'notRun';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EXPECTED
     * @uses self::VALUE_NOT_EXPECTED
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_ASSIGNED
     * @uses self::VALUE_SIGNED_ON
     * @uses self::VALUE_AT_ORIGIN
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_ABORTED
     * @uses self::VALUE_OFF_ROUTE
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_ASSUMED_COMPLETED
     * @uses self::VALUE_NOT_RUN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXPECTED,
            self::VALUE_NOT_EXPECTED,
            self::VALUE_CANCELLED,
            self::VALUE_ASSIGNED,
            self::VALUE_SIGNED_ON,
            self::VALUE_AT_ORIGIN,
            self::VALUE_IN_PROGRESS,
            self::VALUE_ABORTED,
            self::VALUE_OFF_ROUTE,
            self::VALUE_COMPLETED,
            self::VALUE_ASSUMED_COMPLETED,
            self::VALUE_NOT_RUN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
