<?php

namespace EnumType;

/**
 * This class stands for VehicleModesEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: MODEs of transport applicable to timetabled public transport.
 * @subpackage Enumerations
 */
class VehicleModesEnumeration
{
    /**
     * Constant for value 'air'
     * @return string 'air'
     */
    const VALUE_AIR = 'air';
    /**
     * Constant for value 'bus'
     * @return string 'bus'
     */
    const VALUE_BUS = 'bus';
    /**
     * Constant for value 'coach'
     * @return string 'coach'
     */
    const VALUE_COACH = 'coach';
    /**
     * Constant for value 'ferry'
     * @return string 'ferry'
     */
    const VALUE_FERRY = 'ferry';
    /**
     * Constant for value 'metro'
     * @return string 'metro'
     */
    const VALUE_METRO = 'metro';
    /**
     * Constant for value 'rail'
     * @return string 'rail'
     */
    const VALUE_RAIL = 'rail';
    /**
     * Constant for value 'tram'
     * @return string 'tram'
     */
    const VALUE_TRAM = 'tram';
    /**
     * Constant for value 'underground'
     * @return string 'underground'
     */
    const VALUE_UNDERGROUND = 'underground';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AIR
     * @uses self::VALUE_BUS
     * @uses self::VALUE_COACH
     * @uses self::VALUE_FERRY
     * @uses self::VALUE_METRO
     * @uses self::VALUE_RAIL
     * @uses self::VALUE_TRAM
     * @uses self::VALUE_UNDERGROUND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AIR,
            self::VALUE_BUS,
            self::VALUE_COACH,
            self::VALUE_FERRY,
            self::VALUE_METRO,
            self::VALUE_RAIL,
            self::VALUE_TRAM,
            self::VALUE_UNDERGROUND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
