<?php

namespace EnumType;

/**
 * This class stands for VehicleEquipmentEnum EnumType
 * @subpackage Enumerations
 */
class VehicleEquipmentEnum
{
    /**
     * Constant for value 'notUsingSnowChains'
     * @return string 'notUsingSnowChains'
     */
    const VALUE_NOT_USING_SNOW_CHAINS = 'notUsingSnowChains';
    /**
     * Constant for value 'notUsingSnowChainsOrTyres'
     * @return string 'notUsingSnowChainsOrTyres'
     */
    const VALUE_NOT_USING_SNOW_CHAINS_OR_TYRES = 'notUsingSnowChainsOrTyres';
    /**
     * Constant for value 'snowChainsInUse'
     * @return string 'snowChainsInUse'
     */
    const VALUE_SNOW_CHAINS_IN_USE = 'snowChainsInUse';
    /**
     * Constant for value 'snowTyresInUse'
     * @return string 'snowTyresInUse'
     */
    const VALUE_SNOW_TYRES_IN_USE = 'snowTyresInUse';
    /**
     * Constant for value 'snowChainsOrTyresInUse'
     * @return string 'snowChainsOrTyresInUse'
     */
    const VALUE_SNOW_CHAINS_OR_TYRES_IN_USE = 'snowChainsOrTyresInUse';
    /**
     * Constant for value 'withoutSnowTyresOrChainsOnBoard'
     * @return string 'withoutSnowTyresOrChainsOnBoard'
     */
    const VALUE_WITHOUT_SNOW_TYRES_OR_CHAINS_ON_BOARD = 'withoutSnowTyresOrChainsOnBoard';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_USING_SNOW_CHAINS
     * @uses self::VALUE_NOT_USING_SNOW_CHAINS_OR_TYRES
     * @uses self::VALUE_SNOW_CHAINS_IN_USE
     * @uses self::VALUE_SNOW_TYRES_IN_USE
     * @uses self::VALUE_SNOW_CHAINS_OR_TYRES_IN_USE
     * @uses self::VALUE_WITHOUT_SNOW_TYRES_OR_CHAINS_ON_BOARD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_USING_SNOW_CHAINS,
            self::VALUE_NOT_USING_SNOW_CHAINS_OR_TYRES,
            self::VALUE_SNOW_CHAINS_IN_USE,
            self::VALUE_SNOW_TYRES_IN_USE,
            self::VALUE_SNOW_CHAINS_OR_TYRES_IN_USE,
            self::VALUE_WITHOUT_SNOW_TYRES_OR_CHAINS_ON_BOARD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
