<?php

namespace EnumType;

/**
 * This class stands for TypeOfStopPlaceEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed categories of stop place.
 * @subpackage Enumerations
 */
class TypeOfStopPlaceEnumeration
{
    /**
     * Constant for value 'onstreetBus'
     * @return string 'onstreetBus'
     */
    const VALUE_ONSTREET_BUS = 'onstreetBus';
    /**
     * Constant for value 'onstreetTram'
     * @return string 'onstreetTram'
     */
    const VALUE_ONSTREET_TRAM = 'onstreetTram';
    /**
     * Constant for value 'ferryStop'
     * @return string 'ferryStop'
     */
    const VALUE_FERRY_STOP = 'ferryStop';
    /**
     * Constant for value 'airport'
     * @return string 'airport'
     */
    const VALUE_AIRPORT = 'airport';
    /**
     * Constant for value 'railStation'
     * @return string 'railStation'
     */
    const VALUE_RAIL_STATION = 'railStation';
    /**
     * Constant for value 'metroStation'
     * @return string 'metroStation'
     */
    const VALUE_METRO_STATION = 'metroStation';
    /**
     * Constant for value 'coachStation'
     * @return string 'coachStation'
     */
    const VALUE_COACH_STATION = 'coachStation';
    /**
     * Constant for value 'ferryPort'
     * @return string 'ferryPort'
     */
    const VALUE_FERRY_PORT = 'ferryPort';
    /**
     * Constant for value 'harbourPort'
     * @return string 'harbourPort'
     */
    const VALUE_HARBOUR_PORT = 'harbourPort';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONSTREET_BUS
     * @uses self::VALUE_ONSTREET_TRAM
     * @uses self::VALUE_FERRY_STOP
     * @uses self::VALUE_AIRPORT
     * @uses self::VALUE_RAIL_STATION
     * @uses self::VALUE_METRO_STATION
     * @uses self::VALUE_COACH_STATION
     * @uses self::VALUE_FERRY_PORT
     * @uses self::VALUE_HARBOUR_PORT
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONSTREET_BUS,
            self::VALUE_ONSTREET_TRAM,
            self::VALUE_FERRY_STOP,
            self::VALUE_AIRPORT,
            self::VALUE_RAIL_STATION,
            self::VALUE_METRO_STATION,
            self::VALUE_COACH_STATION,
            self::VALUE_FERRY_PORT,
            self::VALUE_HARBOUR_PORT,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
