<?php

namespace EnumType;

/**
 * This class stands for TrafficTypeEnum EnumType
 * @subpackage Enumerations
 */
class TrafficTypeEnum
{
    /**
     * Constant for value 'accessOnlyTraffic'
     * @return string 'accessOnlyTraffic'
     */
    const VALUE_ACCESS_ONLY_TRAFFIC = 'accessOnlyTraffic';
    /**
     * Constant for value 'destinedForAirport'
     * @return string 'destinedForAirport'
     */
    const VALUE_DESTINED_FOR_AIRPORT = 'destinedForAirport';
    /**
     * Constant for value 'destinedForAirportArrivals'
     * @return string 'destinedForAirportArrivals'
     */
    const VALUE_DESTINED_FOR_AIRPORT_ARRIVALS = 'destinedForAirportArrivals';
    /**
     * Constant for value 'destinedForAirportDepartures'
     * @return string 'destinedForAirportDepartures'
     */
    const VALUE_DESTINED_FOR_AIRPORT_DEPARTURES = 'destinedForAirportDepartures';
    /**
     * Constant for value 'destinedForFerryService'
     * @return string 'destinedForFerryService'
     */
    const VALUE_DESTINED_FOR_FERRY_SERVICE = 'destinedForFerryService';
    /**
     * Constant for value 'destinedForRailService'
     * @return string 'destinedForRailService'
     */
    const VALUE_DESTINED_FOR_RAIL_SERVICE = 'destinedForRailService';
    /**
     * Constant for value 'holidayTraffic'
     * @return string 'holidayTraffic'
     */
    const VALUE_HOLIDAY_TRAFFIC = 'holidayTraffic';
    /**
     * Constant for value 'localTraffic'
     * @return string 'localTraffic'
     */
    const VALUE_LOCAL_TRAFFIC = 'localTraffic';
    /**
     * Constant for value 'longDistanceTraffic'
     * @return string 'longDistanceTraffic'
     */
    const VALUE_LONG_DISTANCE_TRAFFIC = 'longDistanceTraffic';
    /**
     * Constant for value 'regionalTraffic'
     * @return string 'regionalTraffic'
     */
    const VALUE_REGIONAL_TRAFFIC = 'regionalTraffic';
    /**
     * Constant for value 'residentsOnlyTraffic'
     * @return string 'residentsOnlyTraffic'
     */
    const VALUE_RESIDENTS_ONLY_TRAFFIC = 'residentsOnlyTraffic';
    /**
     * Constant for value 'throughTraffic'
     * @return string 'throughTraffic'
     */
    const VALUE_THROUGH_TRAFFIC = 'throughTraffic';
    /**
     * Constant for value 'visitorTraffic'
     * @return string 'visitorTraffic'
     */
    const VALUE_VISITOR_TRAFFIC = 'visitorTraffic';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCESS_ONLY_TRAFFIC
     * @uses self::VALUE_DESTINED_FOR_AIRPORT
     * @uses self::VALUE_DESTINED_FOR_AIRPORT_ARRIVALS
     * @uses self::VALUE_DESTINED_FOR_AIRPORT_DEPARTURES
     * @uses self::VALUE_DESTINED_FOR_FERRY_SERVICE
     * @uses self::VALUE_DESTINED_FOR_RAIL_SERVICE
     * @uses self::VALUE_HOLIDAY_TRAFFIC
     * @uses self::VALUE_LOCAL_TRAFFIC
     * @uses self::VALUE_LONG_DISTANCE_TRAFFIC
     * @uses self::VALUE_REGIONAL_TRAFFIC
     * @uses self::VALUE_RESIDENTS_ONLY_TRAFFIC
     * @uses self::VALUE_THROUGH_TRAFFIC
     * @uses self::VALUE_VISITOR_TRAFFIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCESS_ONLY_TRAFFIC,
            self::VALUE_DESTINED_FOR_AIRPORT,
            self::VALUE_DESTINED_FOR_AIRPORT_ARRIVALS,
            self::VALUE_DESTINED_FOR_AIRPORT_DEPARTURES,
            self::VALUE_DESTINED_FOR_FERRY_SERVICE,
            self::VALUE_DESTINED_FOR_RAIL_SERVICE,
            self::VALUE_HOLIDAY_TRAFFIC,
            self::VALUE_LOCAL_TRAFFIC,
            self::VALUE_LONG_DISTANCE_TRAFFIC,
            self::VALUE_REGIONAL_TRAFFIC,
            self::VALUE_RESIDENTS_ONLY_TRAFFIC,
            self::VALUE_THROUGH_TRAFFIC,
            self::VALUE_VISITOR_TRAFFIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
