<?php

namespace EnumType;

/**
 * This class stands for TrafficTrendTypeEnum EnumType
 * @subpackage Enumerations
 */
class TrafficTrendTypeEnum
{
    /**
     * Constant for value 'trafficBuildingUp'
     * @return string 'trafficBuildingUp'
     */
    const VALUE_TRAFFIC_BUILDING_UP = 'trafficBuildingUp';
    /**
     * Constant for value 'trafficEasing'
     * @return string 'trafficEasing'
     */
    const VALUE_TRAFFIC_EASING = 'trafficEasing';
    /**
     * Constant for value 'trafficStable'
     * @return string 'trafficStable'
     */
    const VALUE_TRAFFIC_STABLE = 'trafficStable';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRAFFIC_BUILDING_UP
     * @uses self::VALUE_TRAFFIC_EASING
     * @uses self::VALUE_TRAFFIC_STABLE
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRAFFIC_BUILDING_UP,
            self::VALUE_TRAFFIC_EASING,
            self::VALUE_TRAFFIC_STABLE,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
