<?php

namespace EnumType;

/**
 * This class stands for TpegLoc03AreaDescriptorSubtypeEnum EnumType
 * @subpackage Enumerations
 */
class TpegLoc03AreaDescriptorSubtypeEnum
{
    /**
     * Constant for value 'administrativeAreaName'
     * @return string 'administrativeAreaName'
     */
    const VALUE_ADMINISTRATIVE_AREA_NAME = 'administrativeAreaName';
    /**
     * Constant for value 'administrativeReferenceName'
     * @return string 'administrativeReferenceName'
     */
    const VALUE_ADMINISTRATIVE_REFERENCE_NAME = 'administrativeReferenceName';
    /**
     * Constant for value 'areaName'
     * @return string 'areaName'
     */
    const VALUE_AREA_NAME = 'areaName';
    /**
     * Constant for value 'countyName'
     * @return string 'countyName'
     */
    const VALUE_COUNTY_NAME = 'countyName';
    /**
     * Constant for value 'lakeName'
     * @return string 'lakeName'
     */
    const VALUE_LAKE_NAME = 'lakeName';
    /**
     * Constant for value 'nationName'
     * @return string 'nationName'
     */
    const VALUE_NATION_NAME = 'nationName';
    /**
     * Constant for value 'policeForceControlAreaName'
     * @return string 'policeForceControlAreaName'
     */
    const VALUE_POLICE_FORCE_CONTROL_AREA_NAME = 'policeForceControlAreaName';
    /**
     * Constant for value 'regionName'
     * @return string 'regionName'
     */
    const VALUE_REGION_NAME = 'regionName';
    /**
     * Constant for value 'seaName'
     * @return string 'seaName'
     */
    const VALUE_SEA_NAME = 'seaName';
    /**
     * Constant for value 'townName'
     * @return string 'townName'
     */
    const VALUE_TOWN_NAME = 'townName';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ADMINISTRATIVE_AREA_NAME
     * @uses self::VALUE_ADMINISTRATIVE_REFERENCE_NAME
     * @uses self::VALUE_AREA_NAME
     * @uses self::VALUE_COUNTY_NAME
     * @uses self::VALUE_LAKE_NAME
     * @uses self::VALUE_NATION_NAME
     * @uses self::VALUE_POLICE_FORCE_CONTROL_AREA_NAME
     * @uses self::VALUE_REGION_NAME
     * @uses self::VALUE_SEA_NAME
     * @uses self::VALUE_TOWN_NAME
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ADMINISTRATIVE_AREA_NAME,
            self::VALUE_ADMINISTRATIVE_REFERENCE_NAME,
            self::VALUE_AREA_NAME,
            self::VALUE_COUNTY_NAME,
            self::VALUE_LAKE_NAME,
            self::VALUE_NATION_NAME,
            self::VALUE_POLICE_FORCE_CONTROL_AREA_NAME,
            self::VALUE_REGION_NAME,
            self::VALUE_SEA_NAME,
            self::VALUE_TOWN_NAME,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
