<?php

namespace EnumType;

/**
 * This class stands for TpegLoc01SimplePointLocationSubtypeEnum EnumType
 * @subpackage Enumerations
 */
class TpegLoc01SimplePointLocationSubtypeEnum
{
    /**
     * Constant for value 'intersection'
     * @return string 'intersection'
     */
    const VALUE_INTERSECTION = 'intersection';
    /**
     * Constant for value 'nonLinkedPoint'
     * @return string 'nonLinkedPoint'
     */
    const VALUE_NON_LINKED_POINT = 'nonLinkedPoint';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INTERSECTION
     * @uses self::VALUE_NON_LINKED_POINT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INTERSECTION,
            self::VALUE_NON_LINKED_POINT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
