<?php

namespace EnumType;

/**
 * This class stands for TpegLoc01AreaLocationSubtypeEnum EnumType
 * @subpackage Enumerations
 */
class TpegLoc01AreaLocationSubtypeEnum
{
    /**
     * Constant for value 'largeArea'
     * @return string 'largeArea'
     */
    const VALUE_LARGE_AREA = 'largeArea';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LARGE_AREA
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LARGE_AREA,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
