<?php

namespace EnumType;

/**
 * This class stands for TicketRestrictionEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for TicketRestrictionTypeTPEG pti_table 25.
 * @subpackage Enumerations
 */
class TicketRestrictionEnumeration
{
    /**
     * Constant for value 'pti25_0'
     * @return string 'pti25_0'
     */
    const VALUE_PTI_25_0 = 'pti25_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti25_1'
     * @return string 'pti25_1'
     */
    const VALUE_PTI_25_1 = 'pti25_1';
    /**
     * Constant for value 'allTicketClassesValid'
     * @return string 'allTicketClassesValid'
     */
    const VALUE_ALL_TICKET_CLASSES_VALID = 'allTicketClassesValid';
    /**
     * Constant for value 'pti25_2'
     * @return string 'pti25_2'
     */
    const VALUE_PTI_25_2 = 'pti25_2';
    /**
     * Constant for value 'fullFareOnly'
     * @return string 'fullFareOnly'
     */
    const VALUE_FULL_FARE_ONLY = 'fullFareOnly';
    /**
     * Constant for value 'pti25_3'
     * @return string 'pti25_3'
     */
    const VALUE_PTI_25_3 = 'pti25_3';
    /**
     * Constant for value 'certainTicketsOnly'
     * @return string 'certainTicketsOnly'
     */
    const VALUE_CERTAIN_TICKETS_ONLY = 'certainTicketsOnly';
    /**
     * Constant for value 'pti25_4'
     * @return string 'pti25_4'
     */
    const VALUE_PTI_25_4 = 'pti25_4';
    /**
     * Constant for value 'ticketWithReservation'
     * @return string 'ticketWithReservation'
     */
    const VALUE_TICKET_WITH_RESERVATION = 'ticketWithReservation';
    /**
     * Constant for value 'pti25_5'
     * @return string 'pti25_5'
     */
    const VALUE_PTI_25_5 = 'pti25_5';
    /**
     * Constant for value 'specialFare'
     * @return string 'specialFare'
     */
    const VALUE_SPECIAL_FARE = 'specialFare';
    /**
     * Constant for value 'pti25_6'
     * @return string 'pti25_6'
     */
    const VALUE_PTI_25_6 = 'pti25_6';
    /**
     * Constant for value 'onlyTicketsOfSpecifiedOperator'
     * @return string 'onlyTicketsOfSpecifiedOperator'
     */
    const VALUE_ONLY_TICKETS_OF_SPECIFIED_OPERATOR = 'onlyTicketsOfSpecifiedOperator';
    /**
     * Constant for value 'pti25_7'
     * @return string 'pti25_7'
     */
    const VALUE_PTI_25_7 = 'pti25_7';
    /**
     * Constant for value 'noRestrictions'
     * @return string 'noRestrictions'
     */
    const VALUE_NO_RESTRICTIONS = 'noRestrictions';
    /**
     * Constant for value 'pti25_8'
     * @return string 'pti25_8'
     */
    const VALUE_PTI_25_8 = 'pti25_8';
    /**
     * Constant for value 'noOffPeakTickets'
     * @return string 'noOffPeakTickets'
     */
    const VALUE_NO_OFF_PEAK_TICKETS = 'noOffPeakTickets';
    /**
     * Constant for value 'pti25_9'
     * @return string 'pti25_9'
     */
    const VALUE_PTI_25_9 = 'pti25_9';
    /**
     * Constant for value 'noWeekendReturnTickets'
     * @return string 'noWeekendReturnTickets'
     */
    const VALUE_NO_WEEKEND_RETURN_TICKETS = 'noWeekendReturnTickets';
    /**
     * Constant for value 'pti25_10'
     * @return string 'pti25_10'
     */
    const VALUE_PTI_25_10 = 'pti25_10';
    /**
     * Constant for value 'noReducedFareTickets'
     * @return string 'noReducedFareTickets'
     */
    const VALUE_NO_REDUCED_FARE_TICKETS = 'noReducedFareTickets';
    /**
     * Constant for value 'pti25_255'
     * @return string 'pti25_255'
     */
    const VALUE_PTI_25_255 = 'pti25_255';
    /**
     * Constant for value 'unknownTicketRestriction'
     * @return string 'unknownTicketRestriction'
     */
    const VALUE_UNKNOWN_TICKET_RESTRICTION = 'unknownTicketRestriction';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_25_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_25_1
     * @uses self::VALUE_ALL_TICKET_CLASSES_VALID
     * @uses self::VALUE_PTI_25_2
     * @uses self::VALUE_FULL_FARE_ONLY
     * @uses self::VALUE_PTI_25_3
     * @uses self::VALUE_CERTAIN_TICKETS_ONLY
     * @uses self::VALUE_PTI_25_4
     * @uses self::VALUE_TICKET_WITH_RESERVATION
     * @uses self::VALUE_PTI_25_5
     * @uses self::VALUE_SPECIAL_FARE
     * @uses self::VALUE_PTI_25_6
     * @uses self::VALUE_ONLY_TICKETS_OF_SPECIFIED_OPERATOR
     * @uses self::VALUE_PTI_25_7
     * @uses self::VALUE_NO_RESTRICTIONS
     * @uses self::VALUE_PTI_25_8
     * @uses self::VALUE_NO_OFF_PEAK_TICKETS
     * @uses self::VALUE_PTI_25_9
     * @uses self::VALUE_NO_WEEKEND_RETURN_TICKETS
     * @uses self::VALUE_PTI_25_10
     * @uses self::VALUE_NO_REDUCED_FARE_TICKETS
     * @uses self::VALUE_PTI_25_255
     * @uses self::VALUE_UNKNOWN_TICKET_RESTRICTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_25_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_25_1,
            self::VALUE_ALL_TICKET_CLASSES_VALID,
            self::VALUE_PTI_25_2,
            self::VALUE_FULL_FARE_ONLY,
            self::VALUE_PTI_25_3,
            self::VALUE_CERTAIN_TICKETS_ONLY,
            self::VALUE_PTI_25_4,
            self::VALUE_TICKET_WITH_RESERVATION,
            self::VALUE_PTI_25_5,
            self::VALUE_SPECIAL_FARE,
            self::VALUE_PTI_25_6,
            self::VALUE_ONLY_TICKETS_OF_SPECIFIED_OPERATOR,
            self::VALUE_PTI_25_7,
            self::VALUE_NO_RESTRICTIONS,
            self::VALUE_PTI_25_8,
            self::VALUE_NO_OFF_PEAK_TICKETS,
            self::VALUE_PTI_25_9,
            self::VALUE_NO_WEEKEND_RETURN_TICKETS,
            self::VALUE_PTI_25_10,
            self::VALUE_NO_REDUCED_FARE_TICKETS,
            self::VALUE_PTI_25_255,
            self::VALUE_UNKNOWN_TICKET_RESTRICTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
