<?php

namespace EnumType;

/**
 * This class stands for TaxiSubmodesOfTransportEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Taxi ModesOfTransport: TPEG pti_table_11.
 * @subpackage Enumerations
 */
class TaxiSubmodesOfTransportEnumeration
{
    /**
     * Constant for value 'pti11_0'
     * @return string 'pti11_0'
     */
    const VALUE_PTI_11_0 = 'pti11_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti11_1'
     * @return string 'pti11_1'
     */
    const VALUE_PTI_11_1 = 'pti11_1';
    /**
     * Constant for value 'communalTaxi'
     * @return string 'communalTaxi'
     */
    const VALUE_COMMUNAL_TAXI = 'communalTaxi';
    /**
     * Constant for value 'pti11_2'
     * @return string 'pti11_2'
     */
    const VALUE_PTI_11_2 = 'pti11_2';
    /**
     * Constant for value 'waterTaxi'
     * @return string 'waterTaxi'
     */
    const VALUE_WATER_TAXI = 'waterTaxi';
    /**
     * Constant for value 'pti11_3'
     * @return string 'pti11_3'
     */
    const VALUE_PTI_11_3 = 'pti11_3';
    /**
     * Constant for value 'railTaxi'
     * @return string 'railTaxi'
     */
    const VALUE_RAIL_TAXI = 'railTaxi';
    /**
     * Constant for value 'pti11_4'
     * @return string 'pti11_4'
     */
    const VALUE_PTI_11_4 = 'pti11_4';
    /**
     * Constant for value 'bikeTaxi'
     * @return string 'bikeTaxi'
     */
    const VALUE_BIKE_TAXI = 'bikeTaxi';
    /**
     * Constant for value 'pti11_5'
     * @return string 'pti11_5'
     */
    const VALUE_PTI_11_5 = 'pti11_5';
    /**
     * Constant for value 'blackCab'
     * @return string 'blackCab'
     */
    const VALUE_BLACK_CAB = 'blackCab';
    /**
     * Constant for value 'pti11_6'
     * @return string 'pti11_6'
     */
    const VALUE_PTI_11_6 = 'pti11_6';
    /**
     * Constant for value 'miniCab'
     * @return string 'miniCab'
     */
    const VALUE_MINI_CAB = 'miniCab';
    /**
     * Constant for value 'pti11_7'
     * @return string 'pti11_7'
     */
    const VALUE_PTI_11_7 = 'pti11_7';
    /**
     * Constant for value 'allTaxiServices'
     * @return string 'allTaxiServices'
     */
    const VALUE_ALL_TAXI_SERVICES = 'allTaxiServices';
    /**
     * Constant for value 'pti11_255'
     * @return string 'pti11_255'
     */
    const VALUE_PTI_11_255 = 'pti11_255';
    /**
     * Constant for value 'undefinedTaxiService'
     * @return string 'undefinedTaxiService'
     */
    const VALUE_UNDEFINED_TAXI_SERVICE = 'undefinedTaxiService';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_11_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_11_1
     * @uses self::VALUE_COMMUNAL_TAXI
     * @uses self::VALUE_PTI_11_2
     * @uses self::VALUE_WATER_TAXI
     * @uses self::VALUE_PTI_11_3
     * @uses self::VALUE_RAIL_TAXI
     * @uses self::VALUE_PTI_11_4
     * @uses self::VALUE_BIKE_TAXI
     * @uses self::VALUE_PTI_11_5
     * @uses self::VALUE_BLACK_CAB
     * @uses self::VALUE_PTI_11_6
     * @uses self::VALUE_MINI_CAB
     * @uses self::VALUE_PTI_11_7
     * @uses self::VALUE_ALL_TAXI_SERVICES
     * @uses self::VALUE_PTI_11_255
     * @uses self::VALUE_UNDEFINED_TAXI_SERVICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_11_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_11_1,
            self::VALUE_COMMUNAL_TAXI,
            self::VALUE_PTI_11_2,
            self::VALUE_WATER_TAXI,
            self::VALUE_PTI_11_3,
            self::VALUE_RAIL_TAXI,
            self::VALUE_PTI_11_4,
            self::VALUE_BIKE_TAXI,
            self::VALUE_PTI_11_5,
            self::VALUE_BLACK_CAB,
            self::VALUE_PTI_11_6,
            self::VALUE_MINI_CAB,
            self::VALUE_PTI_11_7,
            self::VALUE_ALL_TAXI_SERVICES,
            self::VALUE_PTI_11_255,
            self::VALUE_UNDEFINED_TAXI_SERVICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
